import { Flex, Modal, ModalProps, Radio, Tag } from 'antd';
import { FC, useEffect, useState } from 'react';
import { FlyerCenterAPI } from '~/api';
import { backListPilotType, getAbilityListType } from '~/api/interface/flyerCenterType';
import { InterDataType } from '~/api/interface';

//飞手列表返回类型
type getAbilityList = InterDataType<getAbilityListType>;

//飞手列表返回类型
type flyerListType = InterDataType<backListPilotType>['list'];
interface selfProps {
  onCancel: () => void;
  onOk: () => void;
  flyerItem: flyerListType[0] | undefined;
}

const ApproveAbilityModel: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, flyerItem }) => {
  const [selectedValue, setSelectedValue] = useState(0);
  const [tags, setTags] = useState<getAbilityList>([]);
  const handleRadioChange = (e: any) => {
    setSelectedValue(e.target.value);
  };
  const handleOk = () => {
    FlyerCenterAPI.updatePilotAbility({
      userId: flyerItem?.userAccountId,
      state: selectedValue,
    }).then((res) => {
      if (res.code === '200') {
        onOk();
      }
    });
  };
  //获取飞手二级能力未认证的
  const getPilotSecondAbilityList = () => {
    FlyerCenterAPI.selectInspectionAbility({
      userId: flyerItem?.userAccountId,
      state: 0,
    }).then((res) => {
      if (res.code === '200') {
        setTags(res.result);
      }
    });
  };

  useEffect(() => {
    if (!flyerItem?.id) return;
    getPilotSecondAbilityList();
  }, [open]);
  return (
    <Modal
      title={'飞手申请二级技能'}
      open={open}
      onOk={handleOk}
      onCancel={onCancel}
      width={'500px'}
      centered={true}
    >
      {tags.length ? (
        <div style={{ marginBottom: 16 }}>
          <Flex gap='4px 0' wrap='wrap'>
            {tags.map((tag, index) => (
              <Tag key={index} bordered={false}>
                {tag.otherAbility}
              </Tag>
            ))}
          </Flex>
        </div>
      ) : (
        <div style={{ marginBottom: 16, marginTop: 16 }}>飞手暂无审核技能</div>
      )}
      <div>
        <Radio.Group onChange={handleRadioChange} value={selectedValue}>
          <Radio value='1'>同意</Radio>
          <Radio value='2'>拒绝</Radio>
        </Radio.Group>
      </div>
    </Modal>
  );
};

export default ApproveAbilityModel;
