import { InterFunction, InterListFunction } from '~/api/interface';
// 用户登录
export type BackEndLoginType = InterFunction<
  { accountNo?: string; passWord?: string; remember?: boolean },
  {
    token: string;
    userAccountId: number;
    accountNo: string;
    portType: number;
    uid: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    appUserAccountId?: number;
    companyInfoVO: {
      id: number;
      companyType: number;
      companyName: string;
      fullName: string;
      province: string;
      city: string;
      district: string;
      address: string;
      companyUserName: string;
      phoneNum: string;
      remark: string;
      leader: number;
    };
    roleInfo: {
      id: number;
      roleName: string;
      roleNo: string;
    };
  }
>;
// 上传图片
export type uploadOssType = InterFunction<any, { filePath: string }>;
// 断电上传
export type uploadOssBPType = InterFunction<any, any>;
// V1.0.1-宣传模块管理-分页
export type listModuleInfoPage = InterListFunction<
  {
    keyword?: string;
    moduleCode?: string;
    moduleType?: number;
    port?: number;
  },
  {
    id: number;
    moduleName: string;
    moduleType: number;
    remark: string;
    deleted: number;
    moduleCode: string;
    createTime: string;
  }
>;
// 修改宣传备注
export type updateModuleInfoRemark = InterFunction<
  {
    id: number;
    remark: string;
  },
  NonNullable<unknown>
>;
// V1.0.1-删除宣传模块
export type removeModuleInfo = InterFunction<{ id: number }, NonNullable<unknown>>;
// V1.0.1-宣传模块-新增
export type insertModuleInfo = InterFunction<
  {
    id?: number;
    moduleCode: string;
    moduleName: string;
    moduleType: number;
    remark?: string;
  },
  NonNullable<unknown>
>;
// 宣传模块-修改
export type updateModuleInfo = InterFunction<
  {
    id: number;
    moduleCode?: string;
    moduleName?: string;
    moduleType?: number;
    remark?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner管理-分页
export type listBannerInfoPage = InterListFunction<
  {
    keyword?: string;
    moduleId?: number;
    moduleType?: number;
  },
  {
    bannerImg: string;
    bannerName: string;
    bannerPoster: string;
    bannerType: number;
    bannerUrl: string;
    createTime: string;
    deleted: number;
    detailInfo: string;
    endTime: string;
    goodsId: number;
    id: number;
    moduleId: number;
    sort: number;
    startTime: string;
    textContent: string;
    using: number;
  }
>;
// // V1.0.1-banner-新增
export type insertBannerInfo = InterFunction<
  {
    bannerImg?: string;
    bannerName?: string;
    bannerPoster?: string;
    bannerType?: number;
    bannerUrl?: string;
    detailInfo?: string;
    endTime?: string;
    goodsId?: number;
    id?: number;
    moduleId?: number;
    sort?: number;
    startTime?: string;
    textContent?: string;
    using?: number;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner-修改
export type updateBannerInfo = InterFunction<
  {
    bannerImg?: string;
    bannerName?: string;
    bannerPoster?: string;
    bannerType?: number;
    bannerUrl?: string;
    detailInfo?: string;
    endTime?: string;
    goodsId?: number;
    id?: number;
    moduleId?: number;
    sort?: number;
    startTime?: string;
    textContent?: string;
    using?: number;
  },
  NonNullable<unknown>
>;
// V1.0.1-banner批量删除
export type batchRemoveBannerInfo = InterFunction<any, NonNullable<unknown>>;
// V1.0.1-删除banner
export type removeBannerInfo = InterFunction<{ id: number }, NonNullable<unknown>>;
// V1.0.1-banner-排序交换
export type exchangeBannerInfo = InterFunction<Array<any>, NonNullable<unknown>>;

//手机号筛选小程序用户
export type getUserAccountByPhoneNumType = InterFunction<
  { phoneNum: string },
  { id: number; nickName: string; userName: string; phoneNum: string; uid: string }[]
>;
//获取小程序二维码
export type appletQRCodeType = InterFunction<{ page: string; scene: string }, string>;
//登录信息-获取
export type getLoginInfoType = InterFunction<{ randomLoginCode: string }, any>;

//地区-获取
type locationType = {
  id: number;
  name: string;
  level: number;
  childInfo: locationType[];
};
export type getSecondDistrictInfoType = InterFunction<any, locationType[]>;
// 后台——消息提示
export type getMessageType = InterFunction<
  any,
  {
    pilotMessage: number;
    joinApplyMessage: number;
    orderMessage: number;
    dynamicMessage: number;
  }
>;
// 获取用户信息
export type UserInfoType = {
  accountStatus: number;
  accountType: number;
  companyAuthStatus: number;
  email: string;
  id: number;
  nickName: string;
  phoneNum: string;
  portType: number;
  source: number;
  uid: string;
  userImg: string;
  userName: string;
  userSex: number;
  realNameAuthStatus: number;
  auditStatus: number;
  totalPoints: number;
  xzAuthStatus: number;
  cooperationTagVOS: {
    createTime: string;
    id: number;
    tagDescription: string;
    tagImg: string;
    tagName: string;
    tagRequire: string;
  }[];
  coverPicture: string;
  districtChildId: number;
  region: string;
  briefIntroduction: string;
  companyInfoVO: {
    address: string;
    backImg: string;
    backUserAccountId: number;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    distance: number;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: number;
    remark: string;
    score: string;
    userAccountId: number;
  };
  userRcdVO: {
    createTime: string;
    id: number;
    rcdNickname: string;
    rcdUserId: number;
    rcdUserName: string;
    remark: string;
    userAccountId: number;
  };
  userStateVO: {
    icon: string;
    id: number;
    state: string;
  };
  pilotJoinCompanyInfoVO: {
    address: string;
    backImg: string;
    backUserAccountId: number;
    backUserId: number;
    brandLogo: string;
    brandName: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    content: string;
    creditCode: string;
    distance: number;
    fullName: string;
    id: number;
    lat: number;
    leader: number;
    licenseImg: string;
    lon: number;
    phoneNum: number;
    profileUrl: string;
    remark: string;
    score: string;
    userAccountId: number;
  };
};
