import React, { forwardRef } from 'react';
import { Checkbox, Form, Select, Row, Col } from 'antd';
import './index.scss';

const OtherInfo: React.FC<any> = forwardRef(() => {
  return (
    <div className='other-info'>
      <div className='other-info-title'>其它信息</div>
      <div className='other-info-form'>
        <Form>
          <Form.Item label='搭配服务' name='otherService'>
            <Checkbox.Group>
              <Checkbox>1</Checkbox>
            </Checkbox.Group>
          </Form.Item>

          <Row>
            <Col>
              <span>用服务&gt;云享飞：</span>
            </Col>
            <Col span={8}>
              <Form.Item name='shareFlyServiceId'>
                <Select
                  allowClear
                  placeholder='请选择服务'
                  showSearch
                  filterOption={(input, option) =>
                    (option!.children as unknown as string)
                      .toLowerCase()
                      .includes(input.toLowerCase())
                  }
                >
                  <Select.Option>1</Select.Option>
                </Select>
              </Form.Item>
            </Col>
          </Row>

          <Row>
            <Col>
              <span>&nbsp;&nbsp;&nbsp;&nbsp;我要租&gt;云仓：</span>
            </Col>
            <Col span={8}>
              <Form.Item name='repoId'>
                <Select
                  allowClear
                  placeholder='请选择商品'
                  showSearch
                  filterOption={(input, option) =>
                    (option!.children as unknown as string)
                      .toLowerCase()
                      .includes(input.toLowerCase())
                  }
                >
                  <Select.Option>1</Select.Option>
                </Select>
              </Form.Item>
            </Col>
          </Row>
        </Form>
      </div>
    </div>
  );
});

export default OtherInfo;
