import React, { forwardRef } from 'react';
import { Button, Form, Upload, Input, Radio, Select, Cascader } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import { Uploader } from '~/components/uploader';
import './index.scss';

const BaseInfo: React.FC<any> = forwardRef(() => {
  return (
    <div className='base-info'>
      <div className='base-info-title'>基本信息</div>
      <div className='base-info-form'>
        <Form labelCol={{ span: 2 }} wrapperCol={{ span: 16 }} initialValues={{ shelfStatus: 1 }}>
          <Form.Item
            name='mainFileList'
            label='商品主图'
            rules={[{ required: true, message: '请上传商品主图' }]}
          >
            <Uploader listType='picture-card'>
              <div>上传</div>
            </Uploader>
          </Form.Item>
          <Form.Item label='商品副图' name='subFileList'>
            <Uploader listType='picture-card'>
              <div>上传</div>
            </Uploader>
          </Form.Item>
          <Form.Item label='商品视频'>
            <Upload>
              <Button icon={<UploadOutlined />}>上传视频</Button>
            </Upload>
          </Form.Item>
          <Form.Item
            name='goodsName'
            label='商品名称'
            rules={[{ required: true, message: '请输入商品名称' }]}
          >
            <Input placeholder='请输入商品名称' maxLength={50} style={{ width: '400px' }} />
          </Form.Item>
          <Form.Item
            name='goodsDesc'
            label='商品描述'
            rules={[{ required: true, message: '请输入商品描述' }]}
          >
            <Input.TextArea
              placeholder='请输入商品描述'
              maxLength={70}
              style={{ width: '400px' }}
              rows={4}
              showCount
            />
          </Form.Item>
          <Form.Item
            name='sortTypeId'
            label='所属目录'
            rules={[{ required: true, message: '请选择所属目录' }]}
          >
            <Select placeholder='请选择所属目录' style={{ width: '400px' }}>
              <Select.Option>1</Select.Option>
            </Select>
          </Form.Item>
          <Form.Item
            name='masterTypeId'
            label='商品分类'
            rules={[{ required: true, message: '请选择商品分类' }]}
          >
            <Cascader
              style={{ width: '400px' }}
              fieldNames={{
                label: 'goodsMasterType',
                value: 'goodsMasterTypeId',
                children: 'goodsSlaveTypeDTO',
              }}
              placeholder='请选择商品分类'
              allowClear
            />
          </Form.Item>
          <Form.Item label='商品标签'>
            <Radio.Group>
              <Radio value={false}>不加</Radio>
              <Radio value>加</Radio>
            </Radio.Group>
          </Form.Item>
          <Form.Item
            name='tag'
            label='标签名称'
            rules={[{ required: true, message: '请输入标签名称' }]}
          >
            <Input placeholder='请输入标签名称' style={{ width: '400px' }} maxLength={5} />
          </Form.Item>
          <Form.Item
            label='商品状态'
            name='shelfStatus'
            rules={[{ required: true, message: '请选择商品状态' }]}
          >
            <Select placeholder='请选择商品状态' style={{ width: '400px' }}>
              <Select.Option value={1}>上架</Select.Option>
              <Select.Option value={0}>下架</Select.Option>
            </Select>
          </Form.Item>
        </Form>
      </div>
    </div>
  );
});

export default BaseInfo;
