import { InterFunction, InterListFunction } from '~/api/interface';

//论坛-列表
export type forumListType = InterListFunction<
  { keyword?: string },
  {
    id: number;
    description: string;
    mediaVO: null;
    show: number;
    userBaseInfo: {
      nickName: string;
      userImg: string;
      userName: null;
      phone: string;
      uid: string;
    };
    userAccountId: number;
    dynamicPublishTime: string;
    checkStatus: 0 | 1 | 2;
  }
>;
//论坛-删除
export type deleteForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-隐藏
export type hiddenForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-详情
type detailResponseType = {
  userBaseInfo: {
    nickName: string;
    phone: string;
    uid: string;
    userImg: string;
    userName: string;
  };
  description: string;
  dynamicPublishTime: string;
  id: number;
  likes: boolean;
  likesCount: number;
  mediaVO: { type: number; url: string }[];
  commentCount: number;
  commentAndReplyVO: detailResponseType[];
};
export type forumDetailType = InterFunction<{ dynamicId: number }, detailResponseType>;
//论坛-点赞信息
export type likeUserInfoType = InterFunction<
  { dynamicId: number },
  { nickName: string; userImg: string; userName: string }[]
>;
// 论坛-审核
export type checkDynamicType = InterFunction<
  { dynamicId: number; status: boolean },
  NonNullable<unknown>
>;

// 话题-列表
export type listGambitType = InterFunction<any, any>;
