import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// 账号-列表
export type listBAccountPageType = InterListFunction<
  {
    accountStatus?: number;
    area?: string;
    cityCode?: number;
    districtCode?: number;
    keyword?: string;
    provinceCode?: number;
    rcdCompanyId?: number;
    roleId?: number;
    userIds?: Array<number>;
    userType?: number;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    userImg: string;
    userSex: number;
    email: string;
    source: number;
    accountStatus: number;
    remark: string;
    portType: number;
    createTime: string;
    companyAuthStatus: null;
    cooperationTagId: null;
    companyName: string;
    companyInfoVO: {
      id: number;
      companyType: number;
      companyName: string;
      fullName: string;
      province: string;
      city: string;
      district: string;
      address: string;
      companyUserName: string;
      phoneNum: string;
      remark: string;
    };
    roleInfoDTO: {
      id: number;
      roleName: string;
      roleNo: string;
    };
  }
>;
// 账号-新增
export type insertBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
    companyId: number;
    roleId: number;
  },
  NonNullable<unknown>
>;
// 账号-删除
export type removeBAccountType = InterFunction<
  {
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 账号-修改
export type updateBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-修改密码
export type updatePasswordType = InterFunction<
  {
    accountNo?: string;
    accountStatus?: number;
    alertPwd?: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id?: number;
    passWord?: number;
    phoneNum?: string;
    provinceCode?: number;
    remark?: string;
    userName?: string;
  },
  NonNullable<unknown>
>;
// 单位-列表
export type listCompanyPage = InterListFunction<
  { companyName?: string },
  {
    address: string;
    city: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    district: string;
    fullName: string;
    id: number;
    phoneNum: string;
    province: string;
    remark: string;
  }
>;
// 单位-新增
export type listCompanyAdd = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
  },
  NonNullable<unknown>
>;
// 单位-修改
export type listCompanyUpdate = InterFunction<
  {
    address?: string;
    city?: string;
    companyName?: string;
    companyType?: number;
    companyUserName?: string;
    district?: string;
    fullName?: string;
    id?: number;
    phoneNum?: number;
    province?: string;
    remark?: string;
    area?: string[];
  },
  NonNullable<unknown>
>;
// 单位-地域
export type getSecondDistrictInfo = InterFunction<
  NonNullable<unknown>,
  {
    childInfo: any[];
    id: number;
    name: string;
  }[]
>;
// 单位-删除
export type listCompanyRemove = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
//单位-详情
export type getCompanyInfoByIdType = InterFunction<
  { id: number },
  {
    address: string;
    city: string;
    companyName: string;
    companyType: number;
    companyUserName: string;
    district: string;
    fullName: string;
    id: number;
    phoneNum: string;
    province: string;
    remark: string;
  }
>;
//单位-成员列表
export type listCompanyMembersType = InterItemFunction<
  { companyInfoId: number },
  {
    accountStatus: number;
    accountType: number;
    companyAuthStatus: number;
    companyName: string;
    cooperationTagVOS: {
      createTime: string;
      id: number;
      tagDescription: string;
      tagImg: string;
      tagName: string;
      tagRequire: string;
    }[];
    createTime: string;
    deleted: number;
    email: string;
    id: number;
    inviteCount: number;
    leader: number;
    nickName: string;
    phoneNum: string;
    portType: number;
    realNameAuthStatus: number;
    remark: string;
    source: number;
    uid: string;
    userImg: string;
    userName: string;
    userRcdVO: {
      createTime: string;
      id: number;
      rcdNickname: string;
      rcdUserId: number;
      rcdUserName: string;
      remark: string;
      userAccountId: number;
    };
    userSex: number;
  }[]
>;
//单位-成员绑定
export type bindingCompanyMemberType = InterFunction<
  { companyInfoId: number; userAccountId: number },
  any
>;
//单位-成员解绑
export type unbindCompanyMemberType = InterFunction<
  { companyInfoId: number; userAccountId: number },
  any
>;
//单位-管理员转让
export type transferLeaderType = InterFunction<
  { companyInfoId: number; fromUserAccountId: number; toUserAccountId: number },
  any
>;

//账号权限-列表
export type listRoleInfoPageType = InterItemFunction<
  { numberOrName?: string },
  {
    id: number;
    roleNo: string;
    userName: string;
    roleName: string;
    remark: string;
    superAdmin: number;
  }[]
>;
//账号权限-新增
export type insertRoleInfoType = InterFunction<{ remark?: string; roleName: string }, any>;
//账号权限-编辑
export type updateRoleInfoType = InterFunction<
  { id?: number; remark?: string; roleName: string },
  any
>;
//账号权限-删除
export type deleteRoleInfoType = InterFunction<{ id: number }, any>;
//账号权限-全部菜单列表
type menType = {
  id: number;
  menuName: string;
  pid: number;
  children: menType[];
};
export type listMenuInfoType = InterFunction<any, menType>;
//账号权限-根据id获取权限
export type listRoleMenuInfoType = InterFunction<{ roleId: number }, any>;
//账号权限-修改角色菜单权限
export type updateRoleMenuInfoType = InterFunction<{ menuInfoIds: number[]; roleId: number }, any>;
