import GoodsInfo from './components/goodsInfo';
import RentAttr from './components/rentAttr';
import SkuInfo from './components/skuInfo';
import AddressInfo from './components/addressInfo';
import FooterOperate from './components/footerOperate';
import AccessoryList from './components/accessoryList';
import './index.scss';
import { useEffect, useRef, useState } from 'react';
import { RentManageAPI } from '~/api';
import { filterObjAttr } from '~/utils';
import { message } from 'antd';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { InterDataType } from '~/api/interface';
import { leaseGoodsDetailsType } from '~/api/interface/rentManageType';

//租赁商品详情返回类型
type rentGoodsDetailType = InterDataType<leaseGoodsDetailsType>;
const RentAddOrEdit = () => {
  const navigate = useNavigate();
  const [searchParams] = useSearchParams();

  const goodsInfoRef = useRef<any>();
  const rentAttrRef = useRef<any>();
  const skuInfoRef = useRef<any>();
  const accessoryListRef = useRef<any>();
  const addressInfoRef = useRef<any>();

  //租赁商品-编辑-id
  const [rentGoodsId, setRentGoodsId] = useState<number>(0);
  //租赁-编辑-商品详情
  const [rentGoodsDetails, setRentGoodsDetails] = useState<rentGoodsDetailType>();

  //  保存
  const saveRentGoods = () => {
    Promise.all([
      goodsInfoRef.current.submitGoodsInfoForm(),
      rentAttrRef.current.submitAttrForm(),
      skuInfoRef.current.skuFormSubmit(),
      accessoryListRef.current.accessoryTableFormSubmit(),
      addressInfoRef.current.addressInfoFormSubmit(),
    ])
      .then((values) => {
        const resourcesList = [
          { type: 0, url: values[1].mainImage },
          ...(values[1].subImage?.map((v: string) => ({ type: 1, url: v })) || []),
          ...(values[1].goodsVideo ? [{ type: 2, url: values[1].goodsVideo }] : []),
        ];
        values[2].priceStock = values[2].priceStock.map((v: any) => ({
          ...v,
          stockOut: v.stockOut ? 1 : 0,
        }));
        RentManageAPI[rentGoodsId ? 'editLeaseGoods' : 'addRentGoods']({
          ...values[0],
          ...filterObjAttr(values[1], ['goodsImage', 'goodsVideo']),
          ...values[2],
          leasePartsList: values[3],
          ...values[4],
          resourcesList,
          id: rentGoodsId ? rentGoodsId : undefined,
        }).then(({ code }) => {
          if (code === '200') {
            message.success(rentGoodsId ? '编辑成功' : '新增成功');
            navigate(-1);
          }
        });
      })
      .catch((error: any) => {
        message.warning(error.errorFields[0].errors[0] || error);
        if (error?.errorFields) {
          goodsInfoRef.current
            .getForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
          rentAttrRef.current
            .getForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
          skuInfoRef.current
            .getForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
          skuInfoRef.current
            .getSpecificationForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
          skuInfoRef.current
            .getSpecificationValueForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
          addressInfoRef.current
            .getForm()
            .scrollToField(error.errorFields[0].name[0], { behavior: 'smooth' });
        }
      });
  };

  //获取租赁商品详情
  const getRentGoodsDetail = (id: number) => {
    RentManageAPI.getLeaseGoodsDetails({ id }).then(({ result }) => {
      if (result) {
        setRentGoodsDetails({ ...result });
      }
    });
  };

  useEffect(() => {
    if (searchParams.get('id')) {
      getRentGoodsDetail(Number(searchParams.get('id')));
      setRentGoodsId(Number(searchParams.get('id')));
    }
  }, []);

  return (
    <div className='rent-create-edit'>
      {/*商品信息*/}
      <GoodsInfo ref={goodsInfoRef} rentGoodsDetails={rentGoodsDetails} />
      {/*商品属性*/}
      <RentAttr ref={rentAttrRef} rentGoodsDetails={rentGoodsDetails} />
      {/*价格库存信息*/}
      <SkuInfo ref={skuInfoRef} rentGoodsDetails={rentGoodsDetails} />
      {/*配件清单*/}
      <AccessoryList ref={accessoryListRef} rentGoodsDetails={rentGoodsDetails} />
      {/*物流信息*/}
      <AddressInfo ref={addressInfoRef} rentGoodsDetails={rentGoodsDetails} />
      {/*底部操作栏*/}
      <FooterOperate saveRentGoods={saveRentGoods} />
    </div>
  );
};
export default RentAddOrEdit;
