import React, { useEffect } from 'react';
import { Form, Input, message, Modal } from 'antd';

// 传参类型
interface propType {
  title?: string;
  open: boolean;
  closed: any;
  change: any;
  name?: string;
  data: any;
}

const RemarkChange: React.FC<propType> = (props) => {
  RemarkChange.defaultProps = {
    title: '修改备注',
    name: 'remark',
  };
  // 参数
  const { title, open, closed, change, data, name } = props;
  // 表单钩子
  const [form] = Form.useForm<{ remark: string }>();
  // 关闭弹窗
  const handleCancel = () => {
    form.resetFields();
    closed();
  };
  // 确认事件
  const handleOk = () => {
    form
      .validateFields()
      .then(async (values) => {
        await handleSubmit(values);
      })
      .catch((err) => {
        message
          .warning({
            content: err.errorFields[0].errors[0],
          })
          .then();
      });
  };
  // 提交事件
  const handleSubmit = async (values: { remark: string }) => {
    // console.log(values);
    change({
      id: data.id,
      [name ? name : 'remark']: values.remark,
    });
  };
  // componentDidMount
  useEffect(() => {
    if (!open) return;
    if (!data) return;
    form.setFieldValue('remark', data[name ? name : 'remark']);
    // console.log(data);
  }, [open]);
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      onOk={handleOk}
      destroyOnClose
      width={400}
    >
      <Form name='addForm' form={form} labelAlign='right'>
        <Form.Item label='备注' name='remark' rules={[{ required: true, message: '请输入备注' }]}>
          <Input.TextArea placeholder={'请输入备注'} maxLength={50} allowClear showCount rows={4} />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default RemarkChange;
