import { useEffect, useState } from 'react';
import { InterListType } from '~/api/interface';
import { systemMessageListByUserType } from '~/api/interface/systemManageType';
import { SystemManageAPI } from '~/api';

const MessageChatSystemView = () => {
  // 系统消息列表
  const [systemList, setSystemList] = useState<InterListType<systemMessageListByUserType>>();
  // 获取系统消息列表
  const getSystemList = async () => {
    const res = await SystemManageAPI.systemMessageListByUser({
      pageNo: 1,
      pageSize: 9999,
    });
    if (res && res.code === '200') {
      setSystemList(res.result?.list?.reverse() || []);
    }
  };
  // 组件挂载
  useEffect(() => {
    getSystemList().then();
  }, []);
  // 消息列表副作用
  useEffect(() => {
    if (!systemList?.length) return;
    const contentScroll: any = document.querySelector('.content-scroll');
    const contentList: any = document.querySelector('.content-scroll .content-list');
    if (contentList?.offsetHeight > contentScroll?.offsetHeight) {
      setTimeout(() => {
        contentScroll.scrollTop = contentList.scrollHeight;
      }, 500);
    }
  }, [systemList]);
  return (
    <div className='message-chat-content-view'>
      <div className='content-head flex-start'>
        <img
          className='image'
          src={'https://file.iuav.com/file/sharefly-message-sys-icon.png'}
          alt={'系统消息'}
        />
        <div className='title'>系统消息</div>
      </div>
      <div className='content-scroll' style={{ minHeight: '74vh', border: 'none' }}>
        <div className='content-list'>
          {systemList?.map((i, j) => (
            <div className='list-item flex-center' key={j}>
              <div className='item-date'>{i?.createTime}</div>
              <div className={`item-content flex-start`}>
                <div className='detail'>
                  <div className='text'>{i?.subject}</div>
                  {i?.content && (
                    <div className='text' dangerouslySetInnerHTML={{ __html: i?.content }}></div>
                  )}
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default MessageChatSystemView;
