import { FlyerCenterAPI } from '~/api';
import { useSearchParams, useNavigate } from 'react-router-dom';
import React, { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { backDetailPilotType } from '~/api/interface/flyerCenterType';
import { Badge, Button, Col, Descriptions, Image, Row, Tag } from 'antd';
import './index.scss';
import ApproveModal from './components/approveModal';
import { PlusOutlined } from '@ant-design/icons';
import { Uploader } from '~/components/uploader';

//飞手详情返回类型
type flyerDetailType = InterDataType<backDetailPilotType>;
const FlyerDetail = () => {
  const [searchParams] = useSearchParams();
  const navigate = useNavigate();

  const [isApprove, setIsApprove] = useState<boolean>(false);
  const [flyerId, setFlyerId] = useState<number>(-1);
  const [flyerDetail, setFlyerDetail] = useState<flyerDetailType>();
  const [approveModalShow, setApproveModalShow] = useState<boolean>(false);

  const getFlyerDetail = (id: number) => {
    FlyerCenterAPI.getBackDetailPilot({ id }).then(({ result }) => {
      setFlyerDetail(result);
    });
  };
  //审批弹窗
  const approveFlyerClick = () => {
    setApproveModalShow(true);
  };
  const approveModalCancel = () => {
    setApproveModalShow(false);
  };
  const approveModalOk = () => {
    setApproveModalShow(false);
    getFlyerDetail(flyerId);
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };
  // 转换飞手简历
  const getPilotResume = () => {
    try {
      return JSON.parse(flyerDetail?.pilotResume || '[]')?.map((i: any) => ({
        ...i,
        url: i?.filePath,
      }));
    } catch (e) {
      return [];
    }
  };

  useEffect(() => {
    getFlyerDetail(Number(searchParams.get('id')));
    setFlyerId(Number(searchParams.get('id')));
    setIsApprove(!!searchParams.get('isApprove'));
  }, []);

  return (
    <div className='flyer-detail'>
      <div className='flyer-detail-header'>
        <div className='header-info'>
          {flyerDetail?.userAccountId}({flyerDetail?.userName})
        </div>
        <div className='header-operate'>
          {isApprove && flyerDetail?.auditStatus === 0 ? (
            <Button type='primary' style={{ marginRight: '10px' }} onClick={approveFlyerClick}>
              审批
            </Button>
          ) : (
            ''
          )}
          <Button type='primary' onClick={backRoute}>
            返回
          </Button>
        </div>
      </div>
      <Row justify='space-between'>
        <Col span={11}>
          <div className='flyer-detail-auth'>
            <Descriptions title='执照认证' bordered column={1} labelStyle={{ width: '100px' }}>
              <Descriptions.Item label='执照类型'>
                {flyerDetail?.licenseType === 'OTHER' ? '其它' : flyerDetail?.licenseType}
              </Descriptions.Item>
              <Descriptions.Item label='执照编号'>{flyerDetail?.licenseNumber}</Descriptions.Item>
              <Descriptions.Item label='认证状态'>
                <Badge
                  status={
                    flyerDetail?.auditStatus === 0
                      ? 'processing'
                      : flyerDetail?.auditStatus === 1
                        ? 'success'
                        : 'error'
                  }
                  text={
                    flyerDetail?.auditStatus === 0
                      ? '审核中'
                      : flyerDetail?.auditStatus === 1
                        ? '已通过'
                        : '未通过'
                  }
                />
                {flyerDetail?.auditStatus === 2 ? (
                  <span style={{ color: 'red' }}>({flyerDetail?.reason})</span>
                ) : (
                  ''
                )}
              </Descriptions.Item>
              <Descriptions.Item label='个人简介'>
                {flyerDetail?.individualResume}
              </Descriptions.Item>
              <Descriptions.Item label='执照图片'>
                <Image src={flyerDetail?.licenseUrl} width={100} />
              </Descriptions.Item>
              <Descriptions.Item label='飞手简历'>
                <Uploader
                  listType={'picture-card'}
                  fileUpload
                  disabled={true}
                  defaultFileList={getPilotResume()}
                >
                  <PlusOutlined />
                </Uploader>
              </Descriptions.Item>
            </Descriptions>
          </div>
        </Col>
        <Col span={11}>
          <div className='flyer-detail-ability'>
            <Descriptions title='能力认证' bordered column={1} labelStyle={{ minWidth: '100px' }}>
              <Descriptions.Item label='常驻地'>{flyerDetail?.residentCity}</Descriptions.Item>
              <Descriptions.Item label='工作年限'>{flyerDetail?.yearsOfWorking}</Descriptions.Item>
              <Descriptions.Item label='能力'>
                {flyerDetail?.pilotAbility.map((v) => <Tag key={v.id}>{v.abilityName}</Tag>)}
              </Descriptions.Item>
              <Descriptions.Item label='业务案例'>
                {flyerDetail?.abilityUrl ? (
                  <Image.PreviewGroup>
                    {JSON.parse(flyerDetail?.abilityUrl).map((v: string, index: number) => (
                      <Image
                        src={v}
                        key={index}
                        width={100}
                        height={100}
                        rootClassName='ability-img'
                      />
                    ))}
                  </Image.PreviewGroup>
                ) : (
                  ''
                )}
              </Descriptions.Item>
            </Descriptions>
          </div>
        </Col>
      </Row>
      {/*  审批弹窗*/}
      <ApproveModal
        open={approveModalShow}
        onCancel={approveModalCancel}
        onOk={approveModalOk}
        flyerId={flyerId}
      />
    </div>
  );
};
export default FlyerDetail;
