import React from 'react';
import { Table, Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import './index.scss';
import { ColumnsType } from 'antd/es/table';
const columns: ColumnsType<any> = [
  {
    title: '序号',
    align: 'center',
    render: () => <div>--</div>,
  },
  {
    title: `产品类型`,
    align: 'center',
    // dataIndex: "goodsTypeId",
    render: () => <div>--</div>,
  },
  {
    title: '规格名称',
    align: 'center',
    dataIndex: 'goodsSpecName',
  },
  {
    title: `方案`,
    align: 'center',
    dataIndex: 'skuName',
  },
  {
    title: '选项来源',
    align: 'center',
    dataIndex: 'specIds',
    render: () => <div>--</div>,
  },
  {
    title: '选择方式',
    align: 'center',
    dataIndex: 'chooseType',
    render: () => <div>--</div>,
  },
  {
    title: '是否必选',
    align: 'center',
    dataIndex: 'must',
    render: () => <div>--</div>,
  },
  {
    title: '规格单位',
    align: 'center',
    dataIndex: 'skuUnitId',
    render: () => {
      return <div>--</div>;
    },
  },
  {
    title: '操作',
    align: 'center',
    width: '20%',
    render: () => {
      return (
        <div>
          <Button type='link' style={{ marginRight: '10px' }}>
            编辑
          </Button>
          <Button type='link'>删除</Button>
        </div>
      );
    },
  },
];
const StockSku: React.FC<any> = () => {
  return (
    <div className='stock-sku'>
      <div className='stock-sku-title'>库存规格</div>
      <div className='stock-sku-content'>
        <div className='stock-sku-operate'>
          <Button icon={<PlusOutlined />} type='primary'>
            添加规格
          </Button>
        </div>
        <Table size='small' bordered rowKey='id' pagination={false} columns={columns} />
      </div>
    </div>
  );
};
export default StockSku;
