import axios from '../request';
import {
  addProductType,
  cooperationTagType,
  deleteProductType,
  editProductSpecPriceType,
  editProductType,
  getProductSpecPriceType,
  productDetailType,
  productListType,
  productSpecAddType,
  productSpecDeleteType,
  productSpecEditType,
  ProductSpecListType,
  productSpecPriceType,
} from '~/api/interface/produceManageType';
import dayjs from 'dayjs';

export class ProduceManageAPI {
  // 产品管理-分页列表
  static listPageProductSku: productListType = (data) => {
    return axios.post('/pms/product/spec/listPageProductSku', data);
  };
  // 产品sku管理-删除产品sku
  static removeProductSku: deleteProductType = (params) => {
    return axios.get('/pms/product/spec/removeProductSku', { params });
  };
  // 产品sku管理-新增产品sku
  static addProductSku: addProductType = (data) => {
    return axios.post('/pms/product/spec/addProductSku', data);
  };

  // 产品sku管理-编辑产品sku
  static editProductSku: editProductType = (data) => {
    return axios.post('/pms/product/spec/editProductSku', data);
  };
  // 产品sku管理-编辑单个产品sku时的信息回显
  static getProductSkuDetail: productDetailType = (params) => {
    return axios.get('/pms/product/spec/getProductSkuDetail', { params });
  };

  // 产品规格管理---删除规格
  static removeProductSpec: productSpecDeleteType = (params) => {
    return axios.get('/pms/product/spec/removeProductSpec', { params });
  };
  //产品规格管理---新增规格
  static addProductSpec: productSpecAddType = (data) => {
    return axios.post('/pms/product/spec/addOrEditProductSpec', data);
  };
  //产品规格管理---编辑规格
  static editProductSpec: productSpecEditType = (data) => {
    return axios.post('/pms/product/spec/addOrEditProductSpec', data);
  };
  // 产品sku管理-产品规格管理-分页列表
  static listPageProductSpec: ProductSpecListType = (params) => {
    return axios.get('/pms/product/spec/listPageProductSpec', { params });
  };
  //产品sku管理-产品规格管理-价格配置
  static setProductSpecPrice: productSpecPriceType = (data) => {
    return axios.post('/pms/product/spec/productSpecCPQ', data);
  };
  //产品sku管理-产品规格管理-获取价格配置
  static getProductSpecPrice: getProductSpecPriceType = (data) => {
    return axios.post('/pms/product/spec/getProductSpecCPQ', data);
  };
  //产品sku管理-产品规格管理-价格配置修改
  static editProductSpecPrice: editProductSpecPriceType = (data) => {
    return axios.post('/pms/product/spec/updateProductSpecCPQ', data);
  };
  //加盟标签-列表
  static getCooperationListTag: cooperationTagType = () => {
    return axios.get('/userapp/cooperation/listTag');
  };
}
