import { FC, forwardRef, useImperativeHandle } from 'react';
import './index.scss';
import { Form, Input } from 'antd';
import { baseInfoType } from '~/api/interface/couponManage';

interface selfPops {
  ref: any;
  isDetail: boolean;
}

const BaseInfo: FC<selfPops> = forwardRef(({ isDetail }, ref) => {
  const [baseInfoForm] = Form.useForm<baseInfoType>();

  useImperativeHandle(ref, () => ({
    getForm: () => baseInfoForm,
  }));

  return (
    <div className='split-coupon-base-info'>
      <div className='title'>基本信息</div>
      <div className='base-info-form'>
        <Form
          labelCol={{ span: 2 }}
          wrapperCol={{ span: 5 }}
          form={baseInfoForm}
          disabled={isDetail}
        >
          <Form.Item
            label='优惠券名称'
            name='couponName'
            rules={[{ required: true, message: '请输入优惠券名称' }]}
          >
            <Input placeholder='请输入优惠券名称' maxLength={10} />
          </Form.Item>
        </Form>
      </div>
    </div>
  );
});
export default BaseInfo;
