import { InterFunction, InterListFunction } from '~/api/interface';
// 账号-列表
export type listBAccountPageType = InterListFunction<
  {
    accountStatus?: number;
    area?: string;
    cityCode?: number;
    districtCode?: number;
    keyword?: string;
    provinceCode?: number;
    rcdCompanyId?: number;
    roleId?: number;
    userIds?: Array<number>;
    userType?: number;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    userImg: string;
    userSex: number;
    email: string;
    source: number;
    accountStatus: number;
    remark: string;
    portType: number;
    createTime: string;
    companyAuthStatus: null;
    cooperationTagId: null;
  }
>;
// 账号-新增
export type insertBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-删除
export type removeBAccountType = InterFunction<
  {
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 账号-修改
export type updateBAccountType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
// 账号-修改密码
export type updatePasswordType = InterFunction<
  {
    accountNo: string;
    accountStatus: number;
    alertPwd: number;
    cityCode?: number;
    districtCode?: number;
    email?: string;
    id: number;
    passWord: number;
    phoneNum: string;
    provinceCode?: number;
    remark?: string;
    userName: string;
  },
  NonNullable<unknown>
>;
