// 分类详情
import { InterFunction, InterItemFunction } from '~/api/interface';

export interface GoodsInfo {
  goodsId: number;
  goodsImg: string;
  goodsName: string;
  shelfStatus: number;
  showCode: number;
}

// 分类列表
export interface categoryEntity {
  id: number;
  directoryId: number;
  classifyName: string;
  pid: number;
  description?: any;
  icon: string;
  remark?: any;
  type: number;
  createTime: string;
  children: any[];
  isADD?: boolean;
  level?: number;
}

// 分类目录
export interface categoryDec {
  id: number;
  directoryName: string;
  pid: null;
  type: number;
  directoryType: string;
}

//分类列表类型
type categoryReposeType = {
  id: number;
  classifyName: string;
  icon: string;
  createTime: string;
  children: categoryReposeType[];
  directoryId: number;
  remark: string;
};
export type categoryListType = InterItemFunction<
  { directoryId?: number; type?: number },
  categoryReposeType[]
>;
//目录列表类型-分页
export type directoryPageListType = InterItemFunction<
  { type?: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
//目录列表类型-不分页
export type directoryListType = InterFunction<
  { type: number },
  {
    id: number;
    directoryName: string;
    type: number;
  }[]
>;
