import { FC, useEffect, useState } from 'react';
import { Button, message, Modal } from 'antd';
import { InterDataType, InterListType, InterReqType } from '~/api/interface';
import { CustomManageAPI } from '~/api';
import {
  applyTagDetails,
  approvalApplyTag,
  listUserApplyTag,
} from '~/api/interface/customManageType';
import './index.scss';
import { PlusOutlined } from '@ant-design/icons';
import { Uploader } from '~/components/uploader';

// 列表的类型
type DataType = InterDataType<applyTagDetails>;
// 列表的类型
type TableType = InterListType<listUserApplyTag>;
// 请求的表单类型
type ReqType = InterReqType<approvalApplyTag>;
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}

const AddEditModal: FC<propType> = (props) => {
  AddEditModal.defaultProps = {
    data: undefined,
  };
  // 参数
  const { title, open, closed, data } = props;
  const [applyTagDetail, setApplyTagDetail] = useState<DataType>();
  // 关闭弹窗
  const handleCancel = () => {
    closed();
  };
  // 点击事件
  const handleOk = async (status: boolean) => {
    await handleSubmit({ id: Number(data?.id), status });
  };
  // 提交事件
  const handleSubmit = async (values: ReqType) => {
    const res = await CustomManageAPI.approvalApplyTag(values);
    if (res && res.code === '200') {
      message.success('操作成功');
      handleCancel();
    }
  };
  // 获取审批详情
  const getApplyTagDetails = async () => {
    const res = await CustomManageAPI.applyTagDetails({
      id: data?.id,
      userAccountId: data?.userAccountId,
    });
    if (res && res.code === '200') {
      const { result } = res;
      setApplyTagDetail(result);
    }
  };
  // componentDidMount
  useEffect(() => {
    if (!open) return;
    if (!data) return;
    getApplyTagDetails().then();
    // console.log('data --->', data);
  }, [open]);
  return (
    <Modal open={open} title={title} onCancel={handleCancel} destroyOnClose footer={null}>
      <div className='apply-detail'>
        <div className='detail-text'>确定通过用户提交的加盟申请成为加盟商吗？</div>
        <div className='detail-action'>
          <Button type={'default'} onClick={() => handleOk(false)}>
            驳回
          </Button>
          <Button type={'primary'} onClick={() => handleOk(true)}>
            通过
          </Button>
        </div>
        <div className='detail-title'>企业认证信息</div>
        <div className='detail-item'>
          <div className='item-label'>企业名称:</div>
          <div className='item-value'>{applyTagDetail?.companyName || '无'}</div>
        </div>
        <div className='detail-item'>
          <div className='item-label'>社会信用代码:</div>
          <div className='item-value'>{applyTagDetail?.creditCode || '无'}</div>
        </div>
        <div className='detail-item'>
          <div className='item-label'>工商营业执照:</div>
          <div className='item-value'>
            <Uploader
              listType={'picture-card'}
              fileUpload
              fileLength={1}
              fileSize={10}
              fileType={['image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'image/bmp']}
              defaultFileList={
                applyTagDetail?.licenseImg ? [{ url: applyTagDetail?.licenseImg }] : []
              }
              disabled={true}
            >
              <PlusOutlined />
            </Uploader>
          </div>
        </div>
        <div className='detail-item'>
          <div className='item-label'>附件信息:</div>
          <div className='item-value'>
            <Uploader
              listType={'picture-card'}
              fileUpload
              fileLength={1}
              fileSize={10}
              fileType={['image/png', 'image/jpeg', 'image/jpg', 'image/gif', 'image/bmp']}
              defaultFileList={
                applyTagDetail?.attachmentList?.length
                  ? applyTagDetail?.attachmentList.map((i) => ({ url: i.url }))
                  : []
              }
              disabled={true}
            >
              <PlusOutlined />
            </Uploader>
          </div>
        </div>
        <div className='detail-item'>
          <div className='item-label'>备注:</div>
          <div className='item-value'>{applyTagDetail?.remark || '无'}</div>
        </div>
      </div>
    </Modal>
  );
};

export default AddEditModal;
