import {
  addGoodsType,
  batchOnShelfOrTakeDownType,
  batchRemoveWareInfoType,
  detailGoodsType,
  editGoodsType,
  exchangeGoodsInfoType,
  listGoodsType,
  otherServiceType,
  skuUnitType,
} from '~/api/interface/goodsType';
import axios from '../request';

class GoodsAPI {
  //商品-列表
  static getGoodsList: listGoodsType = (data) => {
    return axios.post('/pms/goods/listPageGoodsInfo', data);
  };
  //商品-新增
  static addGoods: addGoodsType = (data) => {
    return axios.post('/pms/goods/addGoodsInfo', data);
  };
  //商品-编辑
  static editGoods: editGoodsType = (data) => {
    return axios.post('/pms/goods/editGoodsInfo', data);
  };
  //商品-详情
  static getGoodsDetail: detailGoodsType = (params) => {
    return axios.get('/pms/goods/getGoodsInfoDetail', { params });
  };
  // 商品-单位
  static getSkuUnit: skuUnitType = () => {
    return axios.get('/pms/goods/getSkuUnit');
  };
  //  商品-其它服务列表
  static getOtherServiceList: otherServiceType = () => {
    return axios.get('/pms/goods/listOtherService');
  };
  //  商品-批量上下架
  static batchOnShelfOrTakeDown: batchOnShelfOrTakeDownType = (data) => {
    return axios.post('/pms/goods/batchOnShelfOrTakeDown', data);
  };
  //  商品-批量删除
  static batchRemoveWareInfo: batchRemoveWareInfoType = (data) => {
    return axios.post('/pms/goods/batchRemoveWareInfo', data);
  };
  //  商品-上下移动
  static exchangeGoodsInfo: exchangeGoodsInfoType = (params) => {
    return axios.get('/pms/goods/exchangeGoodsInfo', { params });
  };
}
export default GoodsAPI;
