import './index.scss';
import { useEffect, useState } from 'react';
import * as echarts from 'echarts';
import { Progress } from 'antd';
import { DataDashboardsAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { userJoinReportDataType } from '~/api/interface/dataDashboardsType';
// 数据看板-加盟返回类型
type joinReportDataType = InterDataType<userJoinReportDataType>;

let timer: any;
const JoinInfo = () => {
  const [joinReportDataType, setJoinReportDataType] = useState<joinReportDataType>();
  const [listingProducts, setListingProducts] = useState<{ label: string; value: number }[]>([]);
  // 上架商品总数
  const [totalCount, setTotalCount] = useState<number>(0);

  // 数据看板-加盟信息
  const getUserJoinReportData = () => {
    DataDashboardsAPI.getUserJoinReportData().then(({ result }) => {
      if (result) {
        setJoinReportDataType(result);
        setTotalCount(
          result.leaseProduct + result.onlineCourse + result.saleProduct + result.serviceProduct,
        );
        setListingProducts([
          {
            label: '售卖商品',
            value: result.saleProduct,
          },
          {
            label: '出租商品',
            value: result.leaseProduct,
          },
          {
            label: '服务商品',
            value: result.serviceProduct,
          },
          {
            label: '在线课程',
            value: result.onlineCourse,
          },
        ]);
        initEchartsPie([
          { value: result.brandStore, name: '品牌商' },
          { value: result.repairStore, name: '维修商' },
          { value: result.trainingInstitution, name: '培训机构' },
          { value: result.serviceStore, name: '服务商' },
          { value: result.leaseStore, name: '租赁商' },
        ]);
      }
    });
  };
  // 初始化饼图
  const initEchartsPie = (data: { value: number; name: string }[]) => {
    const myChart = echarts.init(document.getElementById('pie'));
    myChart.setOption({
      tooltip: {
        trigger: 'item',
      },
      series: [
        {
          type: 'pie',
          radius: ['40%', '60%'],
          avoidLabelOverlap: false,
          itemStyle: {
            normal: {
              color: function (params: any) {
                const colorList = ['#FF4100', '#6600FF', '#006BFF', '#FF9E00', '#64C9C9'];
                return colorList[params.dataIndex];
              },
            },
          },
          label: {
            formatter: '{value|{c}}\n{name|{b}}',
            rich: {
              name: {
                fontSize: '0.8rem',
                color: '#999',
              },
              value: {
                fontSize: '1.2rem',
                color: '#000',
                fontWeight: 'bold',
                align: 'center',
              },
            },
          },
          data,
        },
      ],
    });
    window.addEventListener('resize', function () {
      myChart.resize();
    });
  };

  // 定时刷新数据
  const refreshData = () => {
    if (timer) clearInterval(timer);
    timer = setInterval(() => {
      getUserJoinReportData();
    }, 600000);
  };
  useEffect(() => {
    getUserJoinReportData();
    refreshData();
  }, []);
  return (
    <div className='join-info'>
      <div className='join-info-card-1'>
        <div className='join-count'>{joinReportDataType?.companyAuthCount}</div>
        <div className='join-meta'>
          已认证企业总数（入驻{joinReportDataType?.joinStoreCount}家）
        </div>
      </div>
      <div className='join-info-card-2'>
        <div className='card-header'>
          <div className='card-header-icon'></div>
          <div className='card-header-title'>入驻商家</div>
        </div>
        <div className='card-echarts' id='pie'></div>
      </div>
      <div className='join-info-card-3'>
        <div className='card-info-left'>
          <div className='card-header'>
            <div className='card-header-icon'></div>
            <div className='card-header-title'>上架商品 (SKU)</div>
            {/*<div className='sku-count'>{totalCount}</div>*/}
          </div>
          <div className='card-progress'>
            {listingProducts.map((v, i) => (
              <div className='progress-item' key={i}>
                <div className='progress-item-label'>{v.label}</div>
                <div className='progress-item-info'>
                  <Progress
                    percent={(v.value / totalCount) * 100}
                    strokeColor='#F4872A'
                    showInfo={false}
                  />
                </div>
                {/*<div className='progress-item-value'>{v.value}</div>*/}
              </div>
            ))}
          </div>
        </div>
        <div className='card-info-right'>
          <div className='sku-count'>{totalCount}</div>
          {listingProducts.map((v, i) => (
            <div className='progress-item-value' key={i}>
              {v.value}
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};
export default JoinInfo;
