import {
  addGambitType,
  checkDynamicType,
  countGambitType,
  deleteForumType,
  deleteGambitType,
  forumDetailType,
  forumListType,
  hiddenForumType,
  likeUserInfoType,
  listGambitType,
  updateGambitType,
} from '~/api/interface/forumManageType';
import axios from '~/api/request';

export class ForumManageAPI {
  //论坛-列表
  static getForumList: forumListType = (data) =>
    axios.post('/release/backstage/forum/listDynamic', data);
  //论坛-删除
  static deleteForum: deleteForumType = (params) =>
    axios.get('/release/backstage/forum/deleteDynamic', { params });
  //论坛-隐藏
  static hiddenForum: hiddenForumType = (params) =>
    axios.get('/release/backstage/forum/hiddenDynamic', { params });
  // 论坛-详情
  static getForumDetail: forumDetailType = (params) =>
    axios.get('/release/dynamic/dynamicDetails', { params });
  //  论坛-点赞人信息
  static getLikeUserInfoList: likeUserInfoType = (params) =>
    axios.get('/release/backstage/forum/likeUserInfo', { params });
  // 动态审核
  static checkDynamic: checkDynamicType = (params) =>
    axios.get('/release/backstage/forum/checkDynamic', { params });
  // 话题-列表
  static getTopicList: listGambitType = (data) => axios.post('/release/gambit/listGambit', data);
  //   话题-新增
  static addGambit: addGambitType = (data) => axios.post('/release/gambit/insertGambit', data);
  //   话题-删除
  static deleteGambit: deleteGambitType = (params) =>
    axios.get('/release/gambit/deleteGambit', { params });
  //   话题-编辑
  static updateGambit: updateGambitType = (data) =>
    axios.post('/release/gambit/updateGambit', data);
  //   话题-统计个数
  static getCountGambit: countGambitType = () =>
    axios.get('/release/backstage/forum/getDynamicAuditSum');
}
