import React from 'react';
import { InterDataType } from '~/api/interface';
import { listUserAndRoleByCompanyIdType } from '~/api/interface/systemManageType';

// 角色列表
type RoleType = InterDataType<listUserAndRoleByCompanyIdType>;

const MessageChatRole: React.FC<{
  roleList: RoleType;
  userAccountId?: number;
  onSelect: (data: RoleType[0]) => void;
}> = ({ roleList, userAccountId, onSelect }) => {
  // 选择事件
  const handleSelect = (data: RoleType[0]) => {
    onSelect?.(data);
  };
  return (
    <div className={'message-chat-role'}>
      {roleList?.map((i, j) => (
        <div
          className={`role-item flex-start ${userAccountId === i?.userAccountId && 'item-active'}`}
          key={j}
          onClick={() => handleSelect(i)}
        >
          <img className={'image'} src={i?.userAccountVO?.userImg} alt={i?.roleName} />
          <div className='content flex-start'>
            <div
              className='title text-ellipsis'
              title={i?.userAccountVO?.nickName || i?.userAccountVO?.userName}
            >
              {i?.userAccountVO?.nickName || i?.userAccountVO?.userName}
            </div>
            <div className='role'>{i?.roleName}</div>
          </div>
        </div>
      ))}
    </div>
  );
};

export default MessageChatRole;
