import { Form, message, Modal, ModalProps, Radio, RadioChangeEvent, Select } from 'antd';
import { FC, useState } from 'react';
import { FlyerCenterAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { backListReasonType } from '~/api/interface/flyerCenterType';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
  flyerId: number;
}
//原因列表返回类型
type reasonType = InterDataType<backListReasonType>;

const ApproveModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, flyerId }) => {
  const [form] = Form.useForm();
  const [auditStatus, setAuditStatus] = useState<number>(1);
  const [reasonList, setReasonList] = useState<reasonType>([]);

  const handleCancel = () => {
    form.resetFields();
    setAuditStatus(-1);
    onCancel();
  };
  const handleOk = () => {
    form.validateFields().then((values) => {
      FlyerCenterAPI.updateAuditStatus({ ...values, id: flyerId }).then(({ code }) => {
        if (code === '200') {
          message.success('审批成功');
          onOk();
          form.resetFields();
          setAuditStatus(-1);
          (window as any).getMessageNumber();
        }
      });
    });
  };
  const radioChange = (e: RadioChangeEvent) => {
    if (e.target.value === 2) {
      getBackListReason();
    }
    setAuditStatus(e.target.value);
  };
  //不通过原因列表
  const getBackListReason = () => {
    FlyerCenterAPI.getBackListReason().then(({ result }) => {
      setReasonList(result || []);
    });
  };

  return (
    <Modal open={open} onCancel={handleCancel} onOk={handleOk} title='审批飞手'>
      <Form form={form} initialValues={{ auditStatus: 1 }}>
        <Form.Item label='状态' name='auditStatus'>
          <Radio.Group onChange={radioChange}>
            <Radio value={1}>已通过</Radio>
            <Radio value={2}>未通过</Radio>
          </Radio.Group>
        </Form.Item>
        {auditStatus !== 2 ? (
          ''
        ) : (
          <Form.Item
            label='原因'
            name='reasonId'
            rules={[{ required: true, message: '请选择原因' }]}
          >
            <Select placeholder='请选择原因'>
              {reasonList.map((v) => (
                <Select.Option value={v.id} key={v.id}>
                  {v.reason}
                </Select.Option>
              ))}
            </Select>
          </Form.Item>
        )}
      </Form>
    </Modal>
  );
};
export default ApproveModal;
