import React, { useEffect, useState } from 'react';
import SearchBox from '~/components/search-box';
import { InterListType, InterReqListType } from '~/api/interface';
import { getListPartnerType } from '~/api/interface/customManageType';
import { CustomManageAPI } from '~/api';
import { Table } from 'antd';
import { ColumnsType } from 'antd/es/table';

// 表格数据类型
type TableType = InterListType<getListPartnerType>;
// 请求类型
type ReqType = InterReqListType<getListPartnerType>;
// 搜索表单的数据
let query: ReqType = {};

const CustomApplyPage: React.FC = () => {
  // 表格分页配置
  const [pagination, setPagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 表格数据
  const [tableData, setTableData] = useState<TableType>([]);
  // 加载列表
  const getTableList = async (value = {}) => {
    // 只需要修改这个地方的接口即可
    const res = await CustomManageAPI.getListPartner({
      pageNo: pagination.current,
      pageSize: pagination.pageSize,
      ...value,
      ...query,
    });
    if (res && res.code === '200') {
      const { list, pageNo, totalCount, pageSize, totalPage } = res.result; // 解构
      setPagination({
        total: totalCount,
        current: pageNo,
        pageSize,
        totalPage,
      });
      setTableData(list);
    }
  };
  // 翻页
  const paginationChange = (pageNo: number, pageSize: number) => {
    getTableList({ pageNo, pageSize }).then();
  };
  // 表单提交
  const onFinish = (data: ReqType) => {
    pagination.current = 1;
    query = data;
    getTableList(data).then();
  };
  // componentDidMount
  useEffect(() => {
    query = {};
    (async () => {
      await getTableList();
    })();
  }, []);
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: '合伙人姓名',
      dataIndex: 'userName',
      align: 'center',
    },
    {
      title: '合伙人电话',
      dataIndex: 'phoneNumber',
      align: 'center',
    },
    {
      title: '申请城市',
      dataIndex: 'userAddress',
      align: 'center',
    },
    {
      title: '申请意向',
      dataIndex: 'intention',
      align: 'center',
      ellipsis: true,
      width: 200,
      render: (text) => text || '无',
    },
    {
      title: '申请时间',
      dataIndex: 'createTime',
      align: 'center',
    },
  ];
  return (
    <>
      <SearchBox
        search={[
          {
            label: '合伙人姓名',
            name: 'userName',
            type: 'input',
            placeholder: '请输入合伙人姓名',
          },
          {
            label: '合伙人电话',
            name: 'phoneNumber',
            type: 'input',
            maxlength: 11,
            placeholder: '请输入合伙人电话',
          },
        ]}
        isSearch={true}
        isReset={true}
        searchData={onFinish}
      />
      <Table
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        bordered={true}
        // scroll={{ x: 1200 }}
        pagination={{
          total: pagination.total,
          pageSize: pagination.pageSize,
          current: pagination.current,
          showSizeChanger: true,
          showQuickJumper: true,
          onChange: (page: number, pageSize: number) => paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
    </>
  );
};

export default CustomApplyPage;
