import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, Table } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import AddOrEditNewsModal from './components/addOrEditNewsModal';
import PreviewNewsModal from './components/previewNewsModal';
import { useState } from 'react';

const IndustryNews = () => {
  const searchColumnsData: searchColumns[] = [
    {
      label: '文章名称',
      type: 'input',
      name: '',
      placeholder: '请输入文章名称',
    },
  ];
  const tableColumns: ColumnsType<any> = [
    {
      title: '序号',
      align: 'center',
    },
    {
      title: '文章名称',
      align: 'center',
    },
    {
      title: '发布时间',
      align: 'center',
    },
    {
      title: '来源',
      align: 'center',
    },
    {
      title: '作者',
      align: 'center',
    },
    {
      title: '封图片',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link'>编辑</Button>
          <Button type='link' onClick={previewClick}>
            预览
          </Button>
          <Button type='link' danger>
            删除
          </Button>
        </>
      ),
    },
  ];
  const [tableData, setTableData] = useState<any>([{ id: 1 }]);
  const [addOrEditNewsModalShow, setAddOrEditNewsModalShow] = useState<boolean>(false);
  const [previewNewsModalShow, setPreviewNewsModalShow] = useState<boolean>(false);

  const addOrEditIndustryNewsClick = () => {
    setAddOrEditNewsModalShow(true);
  };
  const addOrEditNewsModalCancel = () => {
    setAddOrEditNewsModalShow(false);
  };
  const previewClick = () => {
    setPreviewNewsModalShow(true);
  };
  const previewNewsModalCancel = () => {
    setPreviewNewsModalShow(false);
  };
  return (
    <div className='industry-news'>
      <SearchBox
        search={searchColumnsData}
        child={
          <Button type='primary' icon={<PlusOutlined />} onClick={addOrEditIndustryNewsClick}>
            新建
          </Button>
        }
      />
      <Table bordered columns={tableColumns} dataSource={tableData} />
      <AddOrEditNewsModal open={addOrEditNewsModalShow} onCancel={addOrEditNewsModalCancel} />
      <PreviewNewsModal open={previewNewsModalShow} onCancel={previewNewsModalCancel} />
    </div>
  );
};
export default IndustryNews;
