import SearchBox, { searchColumns } from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { useState } from 'react';
import DynamicDetailModal from './components/dynamicDetailModal';

const DynamicList = () => {
  const searchColumnsData: searchColumns[] = [
    {
      label: '作者',
      type: 'input',
      name: '',
      placeholder: '用户名称/用户UID/用户手机号码',
    },
  ];
  const tableColumns: ColumnsType<any> = [
    {
      title: '动态描述信息',
      align: 'center',
    },
    {
      title: '作者（用户名称）',
      align: 'center',
    },
    {
      title: '用户UID',
      align: 'center',
    },
    {
      title: '用户手机号',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link' onClick={lookDynamicDetail}>
            查看详情
          </Button>
          <Button type='link'>强制删除</Button>
          <Button type='link'>强制隐藏</Button>
        </>
      ),
    },
  ];
  const [tableData, setTableData] = useState<any>([{ id: 1 }]);
  const [dynamicDetailModalShow, setDynamicDetailModalShow] = useState<boolean>(false);
  const dynamicDetailModalOnCancel = () => {
    setDynamicDetailModalShow(false);
  };
  //查看详情
  const lookDynamicDetail = () => {
    setDynamicDetailModalShow(true);
  };
  return (
    <div className='dynamic-list'>
      <SearchBox search={searchColumnsData} />
      <Table bordered columns={tableColumns} dataSource={tableData} rowKey='id' />
      <DynamicDetailModal open={dynamicDetailModalShow} onCancel={dynamicDetailModalOnCancel} />
    </div>
  );
};
export default DynamicList;
