import {
  listPublishPageType,
  requirementsListType,
  releaseTenderNews,
  releaseTenderNewsAdd,
  releaseTenderNewsDelete,
  releaseTenderNewsUpdate,
  releaseTenderNewsInfo,
  releaseTenderNewsInfoUpdate,
  releaseTenderNewsApplyList,
} from '~/api/interface/resourceManageType';
import axios from '../request';

export class ResourceManageAPI {
  //需求列表
  static getListPublishPage: listPublishPageType = (data) =>
    axios.post('/release/requirements/listPublishPage', data);
  //  需求类型列表
  static getRequirementTypeList: requirementsListType = () =>
    axios.get('/release/requirements/listType');

  // 查询招标快讯列表-分页
  static releaseTenderNews: releaseTenderNews = (params) =>
    axios.get('/release/tender/news', { params });

  // 新增招标快讯
  static releaseTenderNewsAdd: releaseTenderNewsAdd = (params) =>
    axios.post('/release/tender/news', params);

  // 修改招标快讯
  static releaseTenderNewsUpdate: releaseTenderNewsUpdate = (params) =>
    axios.put('/release/tender/news', params);

  // 删除招标快讯
  static releaseTenderNewsDelete: releaseTenderNewsDelete = (params) =>
    axios.delete(`/release/tender/news/${params?.id}`);

  // 查询-招标快讯详情列表-分页
  static releaseTenderNewsInfo: releaseTenderNewsInfo = (params) =>
    axios.get('/release/tender/info', { params });

  // 修改-招标快讯详情
  static releaseTenderNewsInfoUpdate: releaseTenderNewsInfoUpdate = (params) =>
    axios.put('/release/tender/info', params);

  // 用户反馈列表-分页
  static releaseTenderNewsApplyList: releaseTenderNewsApplyList = (params) =>
    axios.post('/release/tender/applyList', params);
}
