import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';

//需求列表
export type listPublishPageType = InterItemFunction<
  { requirementTypeId?: number; keyword?: string },
  any
>;
//需求类型列表
export type requirementsListType = InterFunction<any, { id: number; typeName: string }[]>;

// 查询招标快讯列表-分页
export type releaseTenderNews = InterListFunction<
  {
    endTime?: string;
    startTime?: string;
    tenderName?: string;
    using?: number;
  },
  {
    createTime: Date;
    id: number;
    port: number;
    tenderName: string;
    using: number;
  }
>;
// 新增招标快讯
export type releaseTenderNewsAdd = InterFunction<any, any>;
// 修改招标快讯
export type releaseTenderNewsUpdate = InterFunction<any, any>;
// 删除招标快讯
export type releaseTenderNewsDelete = InterFunction<{ id: number }, any>;
// 查询-招标快讯详情列表-分页
export type releaseTenderNewsInfo = InterListFunction<
  {
    tenderNewsId?: number;
  },
  {
    createTime: string;
    id: number;
    tenderContent: string;
    tenderInfoNo: string;
    tenderNewsId: number;
    tenderPrice: number;
    tenderTitle: string;
  }
>;
// 修改-招标快讯详情
export type releaseTenderNewsInfoUpdate = InterListFunction<
  {
    id: number;
    tenderContent?: string;
    tenderPrice?: number;
    tenderTitle?: string;
  },
  NonNullable<unknown>
>;
// 用户反馈列表-分页
export type releaseTenderNewsApplyList = InterListFunction<
  {
    tenderInfoId?: number;
    tenderNewsId?: number;
    userName?: string;
  },
  {
    createTime: string;
    id: number;
    nickName: string;
    phoneNum: string;
    tenderInfoId: number;
    tenderInfoNo: string;
    tenderTitle: string;
    userName: string;
  }
>;
