import { Layout } from 'antd';
import { Outlet } from 'react-router-dom';
// eslint-disable-next-line import/no-cycle
import HeaderView from './header';
import { MenuView } from './menu';
import './index.scss';
import { TitleView } from './title';

const { Content } = Layout;
function LayoutView() {
  return (
    <Layout className='layout-view'>
      <TitleView />
      <Layout>
        <MenuView />
        <Layout className='layout-bg'>
          <HeaderView />
          <Content className='layout-content'>
            <Outlet />
          </Content>
        </Layout>
      </Layout>
    </Layout>
  );
}
export default LayoutView;
