import { Form, Modal, ModalProps, Select } from 'antd';
import { FC } from 'react';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
}
const DistributionOrder: FC<ModalProps & selfProps> = ({ open, onCancel, onOk }) => {
  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };
  return (
    <Modal open={open} title='分配订单' onOk={handleOk} onCancel={handleCancel}>
      <Form labelCol={{ span: 6 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='订单编号'></Form.Item>
        <Form.Item label='订单名称'></Form.Item>
        <Form.Item label='分配运营' rules={[{ required: true, message: '请选择运营人员' }]}>
          <Select placeholder='请选择运营人员'></Select>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default DistributionOrder;
