import { FC } from 'react';
import { Form, Modal, ModalProps, Radio } from 'antd';

interface selfProps {
  onCancel: () => void;
  onOk: () => void;
}

const ApprovalOrder: FC<ModalProps & selfProps> = ({ open, onCancel, onOk }) => {
  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };
  return (
    <Modal open={open} title='凭证审批' onOk={handleOk} onCancel={handleCancel}>
      <Form labelCol={{ span: 4 }} wrapperCol={{ span: 12 }}>
        <Form.Item label='状态'>
          <Radio.Group>
            <Radio value={1}>通过</Radio>
            <Radio value={2}>驳回</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item label='凭证'></Form.Item>
      </Form>
    </Modal>
  );
};
export default ApprovalOrder;
