import { InterFunction, InterItemFunction } from '~/api/interface';

//论坛-列表
export type forumListType = InterItemFunction<
  { keyword?: string },
  {
    description: string;
    userBaseInfo: {
      nickName: string;
      phone: string;
      uid: string;
      userImg: string;
      userName: string;
    };
    show: number;
    id: number;
  }[]
>;
//论坛-删除
export type deleteForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-隐藏
export type hiddenForumType = InterFunction<{ dynamicId: number }, any>;
//论坛-详情
type detailResponseType = {
  userBaseInfo: {
    nickName: string;
    phone: string;
    uid: string;
    userImg: string;
    userName: string;
  };
  description: string;
  dynamicPublishTime: string;
  id: number;
  likes: boolean;
  likesCount: number;
  mediaVO: { type: number; url: string }[];
  commentCount: number;
  commentAndReplyVO: detailResponseType[];
};
export type forumDetailType = InterFunction<{ dynamicId: number }, detailResponseType>;
//论坛-点赞信息
export type likeUserInfoType = InterFunction<{ dynamicId: number }, any>;
