import { OrderManageAPI } from '~/api';
import React, { useEffect, useState } from 'react';
import { Timeline } from 'antd';
import { orderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';

// 接口返回的类型
type DataType = InterDataType<orderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType;
};

const DetailTimeLine: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 流程列表
  const [timeLineList, setTimeLineList] = useState<{ label: string; color: string }[]>([]);
  // 获取订单流程
  const getOrderStatus = async () => {
    const res = await OrderManageAPI.listTranStatus({});
    if (res && res.code === '200') {
      // 转换列表数据（区分完成和未完）
      const list = res.result.map((i) => {
        if (Number(i.status) < Number(detail?.tranStatus)) {
          return {
            label: i.doing,
            color: '#1890ff',
          };
        } else {
          return {
            label: i.waiting,
            color: '#ccc',
          };
        }
      });
      // 将当前项目变绿
      const current = list.findIndex((i) => i.color === '#ccc');
      list[current].color = '#52c41a';
      setTimeLineList(list);
    }
  };
  // componentDidMount
  useEffect(() => {
    if (!detail) return;
    getOrderStatus().then();
  }, [detail]);
  return (
    <div className={'detail-timeline'} style={{ width: '200px' }}>
      <div className={'detail-title'}>订单流程</div>
      <Timeline items={timeLineList} mode={'right'} />
    </div>
  );
};

export default DetailTimeLine;
