import { CustomManageAPI } from '~/api';
import { useSearchParams, useNavigate } from 'react-router-dom';
import { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { authDetailType } from '~/api/interface/customManageType';
import { Button, Descriptions, Image } from 'antd';

//实名认证详情返回类信息
type detailType = InterDataType<authDetailType>;
const CustomVerificationDetail = () => {
  const [searchParams] = useSearchParams();
  const navigate = useNavigate();

  const [detail, setDetail] = useState<detailType>();

  const getAuthDetail = (id: number) => {
    CustomManageAPI.getAuthDetail({ id }).then(({ result }) => {
      setDetail(result);
    });
  };
  //返回
  const backRoute = () => {
    navigate(-1);
  };

  useEffect(() => {
    getAuthDetail(Number(searchParams.get('id')));
  }, []);
  return (
    <div className='custom-verification-detail'>
      <Descriptions
        title='认证信息'
        bordered
        column={2}
        extra={
          <Button type='primary' onClick={backRoute}>
            返回
          </Button>
        }
      >
        <Descriptions.Item label='姓名'>{detail?.userName}</Descriptions.Item>
        <Descriptions.Item label='身份证号码'>{detail?.idNumber}</Descriptions.Item>
        <Descriptions.Item label='身份证正面'>
          <Image src={detail?.frontIdImg} width={50} />
        </Descriptions.Item>
        <Descriptions.Item label='身份证反面'>
          <Image src={detail?.backIdImg} width={50} />
        </Descriptions.Item>
      </Descriptions>
    </div>
  );
};
export default CustomVerificationDetail;
