import { Form, Input, message, Modal, ModalProps, Radio } from 'antd';
import { FC } from 'react';
import { DepleteManageTypeAPI } from '~/api';
import { listPageWithdrawalApplyType } from '~/api/interface/depleteManageType';
import { InterListType } from '~/api/interface';

// 提现列表返回类型
type withdrawalApplyType = InterListType<listPageWithdrawalApplyType>;
interface selfProps {
  onOk: () => void;
  onCancel: () => void;
  currentWithDrawItem: withdrawalApplyType[0] | undefined;
}

const ApplyStatusModal: FC<ModalProps & selfProps> = ({
  open,
  onOk,
  onCancel,
  currentWithDrawItem,
}) => {
  const [form] = Form.useForm<{ applyStatus: number; remark?: string }>();

  const handleOk = () => {
    if (currentWithDrawItem) {
      form.validateFields().then((values) => {
        DepleteManageTypeAPI.approveWithdrawalApply({ ...values, id: currentWithDrawItem.id }).then(
          ({ code }) => {
            if (code === '200') {
              message.success('审批成功');
              form.resetFields();
              onOk();
            }
          },
        );
      });
    }
  };
  const handleCancel = () => {
    form.resetFields();
    onCancel();
  };
  return (
    <Modal title='提现审批' open={open} onOk={handleOk} onCancel={handleCancel}>
      <Form
        form={form}
        initialValues={{ applyStatus: 1 }}
        wrapperCol={{ span: 22 }}
        labelCol={{ span: 2 }}
      >
        <Form.Item label='状态' name='applyStatus'>
          <Radio.Group>
            <Radio value={1}>同意</Radio>
            <Radio value={2}>拒绝</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item label='备注' name='remark'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} rows={4} showCount />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default ApplyStatusModal;
