import {
  abilityListType,
  backDetailPilotType,
  backListPilotType,
  backListReasonType,
  backPilotLogListType,
  deletePilotFromTeamType,
  getPilotAuditSumType,
  insertPilotJoinTeamType,
  selectPilotByPhoneType,
  selectPilotListByTeamType,
  updateAuditStatusType,
  updateRemarkType,
} from '~/api/interface/flyerCenterType';
import axios from '../request';

export class FlyerCenterAPI {
  //飞手列表
  static getBackListPilot: backListPilotType = (data) =>
    axios.post('/userapp/pilot/backListPilot', data);
  //修改备注
  static updateRemark: updateRemarkType = (data) => axios.post('/userapp/pilot/updateRemark', data);
  //  飞手能力类型
  static getAbilityList: abilityListType = () => axios.get('/userapp/pilot/abilityList');
  //  飞手认证日志
  static getBackPilotLogList: backPilotLogListType = (data) =>
    axios.post('/userapp/pilot/backPilotLogList', data);
  //  飞手详情
  static getBackDetailPilot: backDetailPilotType = (params) =>
    axios.get('/userapp/pilot/backDetailPilot', { params });
  //  飞手审批
  static updateAuditStatus: updateAuditStatusType = (data) =>
    axios.post('/userapp/pilot/updateAuditStatus', data);
  //  飞手审批不通过原因
  static getBackListReason: backListReasonType = () => axios.get('/userapp/pilot/backListReason');
  //  飞手审批数据统计
  static getPilotAuditSum: getPilotAuditSumType = () =>
    axios.get('/userapp/pilot/getPilotAuditSum');

  // 后台-根据飞手电话号码查找飞手
  static selectPilotByPhone: selectPilotByPhoneType = (params) =>
    axios.get('/userapp/pilot/selectPilotByPhone', { params });

  // 后台-飞手团队添加飞手
  static insertPilotJoinTeam: insertPilotJoinTeamType = (params) =>
    axios.get('/userapp/pilot/insertPilotJoinTeam', { params });

  // 后台-飞手团队-查找属于飞手团队的飞手
  static selectPilotListByTeam: selectPilotListByTeamType = (params) =>
    axios.post('/userapp/pilot/selectPilotListByTeam', params);

  // 后台-飞手团队踢飞手
  static deletePilotFromTeam: deletePilotFromTeamType = (params) =>
    axios.get('/userapp/pilot/deletePilotFromTeam', { params });
}
