import { message } from 'antd';
import * as XLSX from 'xlsx';

// 通过FileReader对象读取文件
export const XLSXFileReader = (file: Blob) => {
  return new Promise((resolve, reject) => {
    const fileReader = new FileReader();
    fileReader.onload = (event) => {
      try {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        const { result } = event.target;
        // 以二进制流方式读取得到整份excel表格对象
        const workbook = XLSX.read(result, { type: 'binary' });
        // 存储获取到的数据
        const data = {};
        // 遍历每张工作表进行读取（这里默认只读取第一张表）
        for (const sheet in workbook.Sheets) {
          const tempData: any[] = [];
          // eslint-disable-next-line
          // eslint-disable-next-line no-prototype-builtins
          if (workbook.Sheets.hasOwnProperty(sheet)) {
            // 利用 sheet_to_json 方法将 excel 转成 json 数据
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            data[sheet] = tempData.concat(XLSX.utils.sheet_to_json(workbook.Sheets[sheet]));
          }
        }
        // console.log(data);
        // 最终获取到并且格式化后的 json 数据
        // message.success('上传成功！').then();
        //上传成功啦,data为上传后的数据
        resolve(data);
      } catch (e) {
        // 这里可以抛出文件类型错误不正确的相关提示
        message.error('文件类型不正确！').then();
        reject(e);
      }
    };
    fileReader.readAsBinaryString(file);
  });
};
