import {
  listPublishPageType,
  requirementsListType,
  releaseTenderNews,
  releaseTenderNewsAdd,
  releaseTenderNewsDelete,
  releaseTenderNewsUpdate,
  addIndustryNewsType,
  industryNewsListType,
  editIndustryNews,
  industryNewsDetailType,
} from '~/api/interface/resourceManageType';
import axios from '../request';

export class ResourceManageAPI {
  //需求列表
  static getListPublishPage: listPublishPageType = (data) =>
    axios.post('/release/requirements/listPublishPage', data);
  //  需求类型列表
  static getRequirementTypeList: requirementsListType = () =>
    axios.get('/release/requirements/listType');

  // 查询招标快讯列表-分页
  static releaseTenderNews: releaseTenderNews = (params) =>
    axios.get('/release/tender/news', { params });

  // 新增招标快讯
  static releaseTenderNewsAdd: releaseTenderNewsAdd = (params) =>
    axios.post('/release/tender/news', params);

  // 修改招标快讯
  static releaseTenderNewsUpdate: releaseTenderNewsUpdate = (params) =>
    axios.put('/release/tender/news', params);

  // 删除招标快讯
  static releaseTenderNewsDelete: releaseTenderNewsDelete = (params) =>
    axios.delete(`/release/tender/news/${params?.id}`);
  //  行业新闻-新增
  static addIndustryNews: addIndustryNewsType = (data) =>
    axios.post('/release/industry-news/insertIndustryNews', data);
  //  行业新闻-列表
  static getIndustryNewsList: industryNewsListType = (data) =>
    axios.post('/release/industry-news/backgroundListNewsPage', data);
  //  行业新闻-编辑
  static editIndustryNews: editIndustryNews = (data) =>
    axios.post('/release/industry-news/upDateIndustryNews', data);
  //  行业新闻-详情
  static getIndustryNewsDetail: industryNewsDetailType = (params) =>
    axios.get('/release/industry-news/details', { params });
}
