import { useEffect, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailDelivery from '~/pages/orderManage/productOrder/comp/detailDelivery';
import DetailPurchaser from '~/pages/orderManage/productOrder/comp/detailPurchaser';
import DetailInformation from '~/pages/orderManage/productOrder/comp/detailInformation';
import { getMallOrderDetailById } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<getMallOrderDetailById>;

function ProductOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 接收到的参数
  const id = searchParams.get('id');
  // 订单状态
  const [orderStatusList, setOrderStatusList] = useState<{ value: number; label: string }[]>([]);
  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DataType>(null!);
  // 获取订单详情
  const getOrderDetail = async () => {
    const res = await OrderManageAPI.getMallOrderDetailById({
      orderId: Number(id),
    });
    if (res && res.code === '200') {
      setOrderDetail(res.result);
      console.log('获取订单详情 --->', res.result);
    }
  };
  // 获取订单状态
  const getOrderStatus = async () => {
    const res = await OrderManageAPI.orderListStatus({});
    if (res && res.code === '200') {
      const list = res.result.map((item) => ({ value: item.code, label: item.status }));
      setOrderStatusList(list);
    }
  };
  // componentDidMount
  useEffect(() => {
    getOrderStatus().then();
    getOrderDetail().then();
    // console.log('拿到的id是 --->', id);
  }, [id]);
  return (
    <div className={'order-detail'}>
      <div className={'order-head'}>
        <div className='head-text'>
          <div>
            <span>订单编号：{orderDetail?.orderNo}</span>
            {/*<span>合同编号：UAV202334741131</span>*/}
          </div>
          <div>
            <span>
              当前状态：
              {orderStatusList?.find((i) => i.value === orderDetail?.statusCode)?.label ||
                orderDetail?.statusCode}
            </span>
            <span>创建时间：{orderDetail?.createTime}</span>
          </div>
        </div>
        <Button type={'primary'} onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className={'detail-wrap'}>
        <DetailPurchaser detail={orderDetail} />
        <DetailDelivery detail={orderDetail} />
        <DetailInformation detail={orderDetail} />
      </div>
    </div>
  );
}

export default ProductOrderDetail;
