import {
  addGoodsType,
  addMallGoodsType,
  batchOnShelfOrTakeDownType,
  batchRemoveWareInfoType,
  detailGoodsType,
  editGoodsType,
  editMallGoodsType,
  exchangeGoodsInfoType,
  listGoodsType,
  listPageGoodsInfoType,
  mallGoodsDetailsType,
  otherServiceType,
  removeMallGoodsType,
  skuUnitType,
  upOrDownShelfType,
} from '~/api/interface/goodsType';
import axios from '../request';

class GoodsAPI {
  //商品-列表
  static getGoodsList: listGoodsType = (data) => {
    return axios.post('/pms/goods/listPageGoodsInfo', data);
  };
  //商品-新增
  static addGoods: addGoodsType = (data) => {
    return axios.post('/pms/goods/addGoodsInfo', data);
  };
  //商品-编辑
  static editGoods: editGoodsType = (data) => {
    return axios.post('/pms/goods/editGoodsInfo', data);
  };
  //商品-详情
  static getGoodsDetail: detailGoodsType = (params) => {
    return axios.get('/pms/goods/getGoodsInfoDetail', { params });
  };
  // 商品-单位
  static getSkuUnit: skuUnitType = () => {
    return axios.get('/pms/mall/goods/getSkuUnit');
  };
  //  商品-其它服务列表
  static getOtherServiceList: otherServiceType = () => {
    return axios.get('/pms/goods/listOtherService');
  };
  //  商品-批量上下架
  static batchOnShelfOrTakeDown: batchOnShelfOrTakeDownType = (data) => {
    return axios.post('/pms/goods/batchOnShelfOrTakeDown', data);
  };
  //商品-单个上下架（新）
  static upOrDownShelf: upOrDownShelfType = (params) =>
    axios.get('/pms/mall/goods/upOrDownShelf', { params });

  //  商品-批量删除
  static batchRemoveWareInfo: batchRemoveWareInfoType = (data) => {
    return axios.post('/pms/goods/batchRemoveWareInfo', data);
  };
  //商品-单个删除
  static removeMallGoods: removeMallGoodsType = (params) =>
    axios.get('/pms/mall/goods/removeMallGoods', { params });
  //  商品-上下移动
  static exchangeGoodsInfo: exchangeGoodsInfoType = (params) => {
    return axios.get('/pms/goods/exchangeGoodsInfo', { params });
  };
  //商品-上下移动
  static exchange: exchangeGoodsInfoType = (params) =>
    axios.get('/pms/mall/goods/exchange', { params });
  //  商品-新增（新）
  static addMallGoods: addMallGoodsType = (data) =>
    axios.post('/pms/mall/goods/addMallGoods', data);
  //商品-编辑（新）
  static editMallGoods: editMallGoodsType = (data) =>
    axios.post('/pms/mall/goods/editMallGoods', data);
  //  商品-列表（新）
  static getListPageGoodsInfo: listPageGoodsInfoType = (data) =>
    axios.post('/pms/mall/goods/listPageGoodsInfo', data);
  //  商品-详情（新）
  static getMallGoodsDetails: mallGoodsDetailsType = (params) =>
    axios.get('/pms/mall/goods/mallGoodsDetails', { params });
}
export default GoodsAPI;
