import { useState } from 'react';
import SearchBox from '~/components/search-box';
import { Button, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { ChangeModal } from '~/pages/customManage/customList/comp/changeModal';

// 表格数据类型
type TableType = any;

function CustomListView() {
  // 是否打开变更弹窗
  const [isChangeVisModal, setIsChangeVisModal] = useState<boolean>(false);
  // 表格分页配置
  const [pagination] = useState({
    total: 0,
    pageSize: 10,
    current: 1,
    totalPage: 0,
  });
  // 表格数据
  const [tableData] = useState<TableType>([{ id: 1 }]);
  // 需要编辑的数据
  const [editData] = useState<TableType[0]>();
  // 表格结构
  const columns: ColumnsType<TableType[0]> = [
    {
      title: '用户UID',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '用户名称',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '手机号',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '认证企业',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '企业认证',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '电子签约认证',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '用户来源',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '创建时间',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '账号类型',
      dataIndex: 'userName',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '渠道等级',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '上级推荐人',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '推荐伙伴',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '相关运营',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '相关销售',
      dataIndex: 'remark',
      align: 'center',
      render: (_text, _record) => `--`,
    },
    {
      title: '操作',
      dataIndex: 'action',
      align: 'center',
      fixed: 'right',
      width: '150px',
      render: (_text, _record) => (
        <>
          <Button
            type={'link'}
            onClick={() => {
              setIsChangeVisModal(true);
            }}
          >
            变更
          </Button>
          <Button type={'link'} danger>
            删除
          </Button>
        </>
      ),
    },
  ];
  return (
    <>
      <SearchBox
        search={[
          {
            label: '用户名称',
            name: 'keyword',
            type: 'input',
            placeholder: '请输入UID、用户名称',
          },
          {
            label: '手机号',
            name: 'phoneNum',
            type: 'input',
            placeholder: '请输入用户账号',
          },
          {
            label: '来源',
            name: 'form',
            type: 'Select',
            placeholder: '请选择相关来源',
            options: [
              { value: 1, label: '自然流' },
              { value: 2, label: '海报' },
              { value: 3, label: '抖音' },
              { value: 4, label: '公众号' },
              { value: 5, label: '社群' },
              { value: 6, label: '招投标' },
            ],
          },
          {
            label: '创建时间',
            name: 'time',
            type: 'rangePicker',
            placeholder: '请选择创建时间',
          },
          {
            label: '企业认证',
            name: 'enterprise',
            type: 'Select',
            placeholder: '请选择是否认证',
            options: [
              { value: 1, label: '未认证' },
              { value: 2, label: '已认证' },
            ],
          },
          {
            label: '电子签约认证',
            name: 'contract',
            type: 'Select',
            placeholder: '请选择是否认证',
            options: [
              { value: 1, label: '未认证' },
              { value: 2, label: '已认证' },
            ],
          },
        ]}
        searchData={(e: any) => console.log('提交数据 --->', e)}
      />
      <Table
        size='small'
        dataSource={tableData}
        columns={columns}
        rowKey='id'
        scroll={{ x: 1200 }}
        pagination={{
          total: pagination.total,
          pageSize: pagination.pageSize,
          current: pagination.current,
          showSizeChanger: true,
          showQuickJumper: true,
          // onChange: (page: number, pageSize: number) =>
          //   paginationChange(page, pageSize),
          showTotal: (total, range) => `当前 ${range[0]}-${range[1]} 条记录 / 共 ${total} 条数据`,
        }}
        // rowSelection={{ selectedRowKeys, onChange: onSelectChange }}
      />
      <ChangeModal
        visible={isChangeVisModal}
        closed={() => {
          setIsChangeVisModal(false);
        }}
        data={editData}
        state={{ levelTags: [] }}
      />
    </>
  );
}

export default CustomListView;
