import { useEffect, useState } from 'react';
import './index.scss';
import { Button, Input } from 'antd';

function MessageBox() {
  const [messageList, setMessageList] = useState<any[]>([]);
  useEffect(() => {
    setMessageList([{ type: 0 }, { type: 1 }, { type: 0 }, { type: 1 }]);
  }, []);
  return (
    <div className={'message-box-wrap'}>
      <div className={'message-box'}>
        {messageList.map((i, j) => (
          <div className={`message-box-item ${i.type === 0 ? 'flex-start' : 'flex-end'}`} key={j}>
            <div className={'item-time'}>2021-01-01 12:00:00</div>
            {i.type === 0 && <div className={'item-userImg'}></div>}
            <div className={'item-content'}>
              红鲤鱼家有头小绿驴叫驴屡屡，绿鲤鱼家有头小红驴叫吕里里，红鲤鱼说它家的驴屡屡要比绿鲤鱼家的吕里里绿，绿鲤鱼说它家的吕里里要比红鲤鱼家的驴屡屡红
            </div>
            {i.type === 1 && <div className={'item-userImg'}></div>}
          </div>
        ))}
      </div>
      <div className='message-action'>
        <Input.TextArea
          placeholder={'请输入消息内容'}
          maxLength={50}
          style={{ width: '60%', marginRight: '15px' }}
          showCount
        />
        <Button type={'primary'}>发送</Button>
      </div>
    </div>
  );
}

export default MessageBox;
