import {
  deleteForumType,
  forumDetailType,
  forumListType,
  hiddenForumType,
  likeUserInfoType,
} from '~/api/interface/forumManageType';
import axios from '~/api/request';

export class ForumManageAPI {
  //论坛-列表
  static getForumList: forumListType = (data) =>
    axios.post('/release/backstage/forum/listDynamic', data);
  //论坛-删除
  static deleteForum: deleteForumType = (params) =>
    axios.get('/release/backstage/forum/deleteDynamic', { params });
  //论坛-隐藏
  static hiddenForum: hiddenForumType = (params) =>
    axios.get('/release/backstage/forum/hiddenDynamic', { params });
  // 论坛-详情
  static getForumDetail: forumDetailType = (params) =>
    axios.get('/release/dynamic/dynamicDetails', { params });
  //  论坛-点赞人信息
  static getLikeUserInfoList: likeUserInfoType = (params) =>
    axios.get('/release/backstage/forum/likeUserInfo', { params });
}
