import { useEffect, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailDelivery from '~/pages/orderManage/equipmentOrder/comp/detailDelivery';
import DetailPurchaser from '~/pages/orderManage/equipmentOrder/comp/detailPurchaser';
import DetailInformation from '~/pages/orderManage/equipmentOrder/comp/detailInformation';
import { OrderManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { rentOrderDetailType } from '~/api/interface/orderManageType';
import DetailTimeLine from '~/pages/orderManage/equipmentOrder/comp/detailTimeLine';

// 接口返回的类型
type DataType = InterDataType<rentOrderDetailType>;

function EquipmentOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 订单id
  const [orderId, setOrderId] = useState<number>(0);
  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DataType>(null!);
  // 获取订单详情
  const getOrderDetail = (id: number) => {
    OrderManageAPI.getRentOrderDetail({
      id,
    }).then(({ result }) => {
      if (result) {
        setOrderDetail(result);
      }
    });
  };
  // componentDidMount
  useEffect(() => {
    setOrderId(Number(searchParams.get('id') || 0));
    getOrderDetail(Number(searchParams.get('id') || 0));
  }, []);
  return (
    <div className={'order-detail'}>
      <div className={'order-head'}>
        <div className='head-text'>
          <div>
            <span>订单编号：{orderDetail?.orderNo}</span>
            <span style={{ display: 'none' }}>合同编号：UAV202334741131</span>
          </div>
          <div>
            <span>当前状态：{orderDetail?.waiting}</span>
            <span>创建时间：{orderDetail?.createTime}</span>
          </div>
        </div>
        <Button type={'primary'} onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className={'detail-wrap'}>
        <DetailPurchaser detail={orderDetail} />
        <DetailDelivery detail={orderDetail} />
        <DetailTimeLine detail={orderDetail} />
        {/*<DetailMessageBox />*/}
        <DetailInformation detail={orderDetail} />
      </div>
    </div>
  );
}

export default EquipmentOrderDetail;
