import React, { useEffect, useState } from 'react';
import { Descriptions, message, Modal } from 'antd';
import { CouponManageAPI } from '~/api';
import { CouponGetDataType } from '~/api/interface/couponManage';

// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: any;
}

// 列表的类型
type DetailType = (ReturnType<CouponGetDataType> extends Promise<infer T> ? T : never)['result'];

const contentStyle = { width: '100px' };

export const DataModal: React.FC<propType> = (props: propType) => {
  // 组件默认值
  DataModal.defaultProps = {
    data: null,
  };
  // 参数
  const { title, open, closed, data } = props;
  // 使用数据
  const [couponDetail, setCouponDetail] = useState<DetailType>();
  // 关闭弹窗
  const handleCancel = () => {
    closed();
  };
  // 获取优惠券使用数据
  const getCouponGetData = async () => {
    const res = await CouponManageAPI.CouponGetData({
      id: data.id,
    });
    if (res && res.code === '200') {
      setCouponDetail(res.result);
    }
  };
  // 组件加载
  useEffect(() => {
    if (!data) return;
    getCouponGetData().then();
  }, [open]);
  return (
    <Modal
      open={open}
      title={title}
      onCancel={handleCancel}
      footer={null}
      destroyOnClose
      width={650}
    >
      <Descriptions column={3} bordered size='small'>
        <Descriptions.Item contentStyle={contentStyle} label='总发行量'>
          {couponDetail?.couponTotal}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label='领取量'>
          {couponDetail?.receiveQuantity}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label='领取率'>
          {couponDetail?.claimRate}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label='使用量'>
          {couponDetail?.usageAmount}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label='有效使用量'>
          {couponDetail?.accountPaid}
        </Descriptions.Item>
        <Descriptions.Item contentStyle={contentStyle} label='有效使用率'>
          {couponDetail?.availability}
        </Descriptions.Item>
      </Descriptions>
    </Modal>
  );
};
