import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// web 租赁订单-分页-列表
export type listOfRentalOrdersType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// 后台管理 租赁订单-分页-列表
export type listPcWechatOrderType = InterListFunction<
  {
    buyerAccount?: string;
    endTime?: string;
    orderNo?: string;
    startTime?: string;
    tranStatus?: string;
    wareNo?: string;
    wareTitle?: string;
  },
  {
    id: number;
    orderNo: string;
    createTime: string;
    wareInfoId: null;
    wareNo: string;
    wareTitle: string;
    wareImg: string;
    skuInfoId: null;
    skuTitle: null;
    repoAccountId: null;
    uid: string;
    buyerName: string;
    buyerPhone: string;
    unitPrice: number;
    wareNum: number;
    shouldPay: number;
    actualPay: number;
    orderType: null;
    deposit: number;
    rentPrice: null;
    startDate: null;
    endDate: null;
    payDay: null;
    tranStatus: string;
    exWare: null;
    remark: string;
    pfRemark: null;
    shutReason: null;
    payNo: null;
    payTime: null;
    sendWareTime: null;
    receipt: {
      id: number;
      receiptMethod: number;
      takeName: string;
      takePhone: string;
      region: string;
      detailAddress: string;
      repoName: null;
      repoAddress: null;
      bookPhone: null;
      sendExCode: null;
      sendExNo: null;
      sendAddress: null;
      renMethod: null;
      renPhone: null;
      renName: null;
      renExCode: null;
      renExNo: null;
      renAddress: null;
      renRepoName: null;
      renRepoAddr: null;
      renRepoPhone: null;
    };
    orderRefund: null;
    express: null;
    refundExpress: null;
    vcus: null;
    returnTime: null;
    couponId: null;
    specsId: null;
    balance: null;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
    nickName: string;
  }
>;
// web/小程序——订单详情
export type orderDetailType = InterFunction<
  { orderNo: string },
  {
    actualPay: number;
    balance: number;
    buyerName: string;
    buyerPhone: string;
    couponId: number;
    createTime: string;
    deposit: number;
    doing: string;
    endDate: string;
    exWare: number;
    express: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    id: number;
    leaseOrderStatus: string;
    nickName: string;
    orderNo: string;
    orderRefund: {
      actualRefund: number;
      createTime: string;
      id: number;
      orderInfo: any;
      orderInfoId: number;
      orderVcu: {
        id: number;
        imgs: Array<string>;
        orderInfoId: number;
        remark: string;
        vcuSatus: number;
        vcuType: number;
        videoUrl: string;
      };
      pfRemark: string;
      reason: string;
      refundCash: {
        amtPaid: number;
        cashAmt: number;
        createUser: number;
        id: number;
        opName: string;
        opNo: string;
        orderNo: string;
        payMethod: number;
        payNo: string;
        payTime: string;
        refundNo: string;
        remark: string;
        voucher: Array<string>;
        wareTitle: string;
      };
      refundNo: string;
      refundStatus: number;
      rlogs: Array<{
        createTime: string;
        msg: string;
        opAccount: string;
        opName: string;
      }>;
      shouldRefund: number;
    };
    orderType: number;
    payDay: number;
    payNo: string;
    payTime: string;
    pfRemark: string;
    receipt: {
      bookPhone: string;
      detailAddress: string;
      id: number;
      receiptMethod: number;
      region: string;
      renAddress: string;
      renExCode: string;
      renExNo: string;
      renMethod: number;
      renName: string;
      renPhone: string;
      renRepoAddr: string;
      renRepoName: string;
      renRepoPhone: string;
      repoAddress: string;
      repoName: string;
      sendAddress: string;
      sendExCode: string;
      sendExNo: string;
      takeName: string;
      takePhone: string;
    };
    refundExpress: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    remark: string;
    rentPrice: number;
    repoAccountId: number;
    returnTime: string;
    sendWareTime: string;
    shouldPay: number;
    shutReason: string;
    skuInfoId: number;
    skuTitle: string;
    specsId: number;
    startDate: string;
    tranStatus: string;
    uid: string;
    unitPrice: number;
    vcus: Array<{
      id: number;
      imgs: Array<string>;
      orderInfoId: number;
      remark: string;
      vcuSatus: number;
      vcuType: number;
      videoUrl: string;
    }>;
    waiting: string;
    wareDescription: string;
    wareImg: string;
    wareInfoId: number;
    wareNo: string;
    wareNum: number;
    wareTitle: string;
  }
>;
// 后台管理——发货-订单/ 卖家发货
export type sendOrderWareType = InterFunction<
  {
    authPwd?: string;
    imgs?: Array<string>;
    orderInfoId?: number;
    orderRefundId?: number;
    remark?: string;
    renAddress?: string;
    renName?: string;
    renPhone?: string;
    sendAddress?: string;
    sendExCode?: string;
    sendExNo?: string;
    vcuSatus?: number;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// 订单状态-字典
export type listTranStatusType = InterFunction<
  NonNullable<unknown>,
  {
    status: string;
    doing: string;
    waiting: string;
    leaseOrderStatus: string;
  }[]
>;
// v1.0.1 物流公司列表-字典
export type listExpressInfoType = InterFunction<
  NonNullable<unknown>,
  {
    exName: string;
    exCode: string;
  }[]
>;
// 物流动态信息
export type logisticsDynamicsType = InterFunction<
  {
    /**
     * exCode
     */
    exCode: string;
    /**
     * exNo
     */
    exNo: string;
  },
  any
>;
// web/小程序 确认收货-订单
export type renterTakeOrderType = InterFunction<
  {
    authPwd: string;
    imgs: Array<string>;
    orderInfoId: number;
    orderRefundId: number;
    remark: string;
    renAddress: string;
    renName: string;
    renPhone: string;
    sendAddress: string;
    sendExCode: string;
    sendExNo: string;
    vcuSatus: number;
    videoUrl: string;
  },
  NonNullable<unknown>
>;
// 后台管理——平台确认归还
export type pfConfirmOrderWareType = InterFunction<
  {
    authPwd?: string;
    imgs?: Array<string>;
    orderInfoId?: number;
    orderRefundId?: number;
    remark?: string;
    renAddress?: string;
    renName?: string;
    renPhone?: string;
    sendAddress?: string;
    sendExCode?: string;
    sendExNo?: string;
    vcuSatus?: number;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// web-小程序——订单详情相关图片信息
export type orderImageDetailType = InterFunction<
  { orderInfoId: number },
  {
    id: number;
    orderInfoId: number;
    vcuType: number;
    vcuSatus: number;
    remark: string;
    imgs: Array<string>;
    videoUrl: string;
  }[]
>;
// 后台管理关闭订单
export type platFormCloseOrderType = InterFunction<
  { orderInfoId: number; shutReason: string },
  NonNullable<unknown>
>;
// 后台管理——驳回/同意退款
export type refundOrderType = InterFunction<
  {
    orderInfoId: number;
    refund: boolean;
  },
  NonNullable<unknown>
>;
//服务-订单
export type serviceOrderType = InterItemFunction<
  { startTime?: string; endTime?: string; orderStatus?: number; orderNameOrNo?: string },
  {
    id: number;
    orderName: string;
    orderNo: string;
    orderStatus: number;
    coverPlan: string;
    orderAmt: number;
    phoneNum: string;
    uid: string;
    createdTime: string;
    userName: string;
    nickName: string;
  }[]
>;
// 服务-订单字典
export type serviceOrderStatusType = InterFunction<
  any,
  { flyerPort: string; orderStatus: number; managePort: string; userPort: string }[]
>;
// 商城订单-订单状态-字典
export type orderListStatus = InterFunction<
  NonNullable<unknown>,
  {
    code: number;
    nextCode: number;
    status: string;
  }[]
>;
// v1.0.0订单管理-分页查询（改版后）
export type listPageManagerVerOne = InterListFunction<
  {
    endTime?: string;
    keyword?: string;
    keyword2?: string;
    saleId?: number;
    showType?: number;
    signStatus?: Array<number>;
    startTime?: string;
    statusCode?: Array<number>;
  },
  {
    contractNo: string;
    contractSignedWay: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    entName: string;
    id: number;
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    mremark: string;
    ogSkuSpecDTOList: null;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderMainImg: string;
    orderName: string;
    orderNo: string;
    payMethod: number;
    phoneNum: string;
    realNameAuth: number;
    realPayAmount: number;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    saleId: number;
    saleName: string;
    shareId: number;
    shareStatus: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    subAmount: number;
    tagName: string;
    totalBuyNum: number;
    uid: string;
    userAccountId: number;
    userName: string;
  }
>;
// v1.0.0订单管理-详情（改版后）
export type getMallOrderDetailById = InterFunction<
  {
    orderId: number;
  },
  {
    archiveDate: string;
    companyName: string;
    contractNo: string;
    contractSignedWay: number;
    cooperationTagId: number;
    couponDiscountAmount: number;
    createTime: string;
    creditPeriod: string;
    deductAmount: number;
    deliveryTime: string;
    discountAmount: number;
    exp: {
      orderId: number;
      sendExpCode: string;
      sendExpNo: string;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
    };
    goodsNum: number;
    id: number;
    kdn: {
      logisticCode: string;
      shipperCode: string;
      stateEx: string;
      traces: Array<{
        acceptStation: string;
        acceptTime: string;
        action: string;
        location: string;
      }>;
    };
    mallOrderProdListDTOList: Array<{
      id: number;
      goodsInfoId: number;
      productName: string;
      model: string;
      prodSkuSpecName: string;
      prodSkuSpecImage: string;
      partNo: string;
      versionDesc: string;
      buyNum: number;
      unitPrice: number;
      skuSpecAmount: number;
    }>;
    manualDiscountAmount: number;
    mremark: string;
    nickName: string;
    ogSkuSpecDTOList: Array<{
      id: number;
      directoryId: number;
      shopCarId: null;
      skuSpecName: string;
    }>;
    operationId: number;
    operationName: string;
    orderAmount: number;
    orderCouponDTOS: Array<{
      couponName: string;
      couponType: number;
      couponUserId: number;
      createTime: string;
      id: number;
      orderId: number;
      useAmount: number;
      useType: number;
    }>;
    orderName: string;
    orderNo: string;
    payErrInfo: string;
    payMethod: number;
    phoneNum: string;
    realityAmount: number;
    recMallUserName: string;
    remark: string;
    serviceNames: Array<string>;
    shareId: number;
    shareStatus: number;
    shopCarAmount: number;
    shutReason: string;
    signStatus: number;
    statusCode: number;
    tagName: string;
    uid: string;
    userAccountId: number;
    userAddress: {
      id: number;
      takeAddress: string;
      takeName: string;
      takePhone: string;
      takeRegion: string;
      type: number;
    };
    userAddressId: number;
    userName: string;
  }
>;

// 需求订单-列表
export type serviceOrderFormListType = InterItemFunction<
  {
    orderAttribute?: number;
    /**
     * 抢单手机号
     */
    preemptPhone?: string;
    /**
     * 发单手机号
     */
    publishPhone?: string;
  },
  {
    /**
     * 订单当前状态
     */
    doing?: string;
    /**
     * id
     */
    id?: number;
    /**
     * 1正常 2争议订单
     */
    orderAttribute?: number;
    /**
     * 平台总收益
     */
    orderEarnings?: number;
    /**
     * 订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER
     */
    orderLevel?: string;
    /**
     * 抢单者电话
     */
    preemptPhone?: string;
    /**
     * 发布者订单编号
     */
    publisherNumber?: string;
    /**
     * 发布者电话
     */
    publishPhone?: string;
    /**
     * 服务类型id
     */
    serviceId?: number;
    /**
     * 服务类型名称
     */
    serviceName?: string;
    waiting: string;
  }[]
>;
// 需求订单-详情
export type serviceOrderFormDetailsType = InterFunction<
  { requirementsInfoId: number },
  {
    cashAmount: number;
    createTime: string;
    id: number;
    latitude: number;
    longitude: number;
    orderAmount: number;
    orderEarnings: number;
    orderEarningsDTO: null;
    preemptCashAmount: number;
    preemptSalaryAmount: number;
    preemptWeChat: number;
    publisherNumber: string;
    requireDescription: string;
    salaryAmount: number;
    serviceId: number;
    serviceName: string;
    taskAddress: string;
    taskEndTime: string;
    taskStartTime: string;
    updateOrderAmount: number;
    weChat: number;
    orderStatus: string;
    duty: number;
    decisionContent: string;
  }
>;
// 需求订单-进度条
export type flowDictionaryType = InterFunction<
  any,
  {
    /**
     * 当前状态
     */
    doing: string;
    /**
     * 飞手当前状态
     */
    flyerPort: string;
    id: number;
    /**
     * 状态码
     */
    orderStatus: string;
    /**
     * 用户当前流程状态
     */
    userPort: string;
    /**
     * 等待状态
     */
    waiting: string;
  }[]
>;
// 需求订单-进度条(带时间)
type flowDictionaryDTO = {
  /**
   * 当前状态
   */
  doing?: string;
  /**
   * 飞手当前状态
   */
  flyerPort?: string;
  id?: number;
  /**
   * 状态码
   */
  orderStatus?: string;
  /**
   * 用户当前流程状态
   */
  userPort?: string;
  /**
   * 等待状态
   */
  waiting?: string;
};
export type flowDictionaryAndTimeType = InterFunction<
  { requirementsInfoId: number },
  {
    amountUpdate?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * 服务需求id
       */
      requirementsInfoId: number;
      updateTime?: Date;
    };
    requirementsServiceDTO?: {
      /**
       * 抢单时间
       */
      createTime?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * 服务id
       */
      requirementsInfoId?: number;
      /**
       * 抢单时间
       */
      updateTime?: string;
    };
    serviceArriveSceneDTO?: {
      /**
       * 到达现场时间
       */
      createTime?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * id
       */
      id?: number;
      /**
       * id
       */
      latitude?: number;
      /**
       * id
       */
      longitude?: number;
      /**
       * 服务需求id
       */
      requirementsInfoId: number;
      /**
       * 现场地址
       */
      sceneAddress?: string;
      /**
       * 现场地址的url
       */
      sceneUrl: string;
      updateTime?: string;
    };
    serviceEvaluateDTO?: {
      createTime?: Date;
      /**
       * 评价内容
       */
      evaluationContent?: string;
      /**
       * 评价图片
       */
      evaluationUrl?: string;
      flowDictionaryDTO?: flowDictionaryDTO;
      /**
       * id
       */
      id?: number;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      /**
       * 星级
       */
      starLevel?: string;
      updateTime?: Date;
    };
    serviceFulfilATaskDTO?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      id?: number;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      /**
       * 完成任务描述
       */
      taskDescribe?: string;
      /**
       * 完成任务图片
       */
      taskUrl?: string;
      updateTime?: Date;
    };
    serviceSettleAccountsDTO?: {
      createTime?: Date;
      flowDictionaryDTO?: flowDictionaryDTO;
      id?: number;
      /**
       * 订单金额
       */
      orderAmount?: number;
      /**
       * 备注
       */
      remark?: string;
      /**
       * 需求id
       */
      requirementsInfoId?: number;
      updateTime?: Date;
    };
  }
>;
// 需求订单-争议处理
export type disputeType = InterFunction<
  {
    /**
     * 客服判定内容
     */
    decisionContent?: string;
    /**
     * 责任问题 1:双方无责 2:发布者责任 3：飞手责任
     */
    duty: number;
    /**
     * id
     */
    requirementsInfoId: number;
  },
  any
>;

// 商城订单-列表（新）
type mallOrderType = {
  /**
   * 卖家企业名称
   */
  companyName?: string;
  /**
   * 确认收货时间
   */
  confirmReceiptTime?: Date;
  /**
   * 下单时间
   */
  createTime: string;
  /**
   * 订单交期
   */
  deliveryTime?: Date;
  /**
   * id
   */
  id: number;
  kdnExpDTO?: {
    logisticCode?: string;
    shipperCode?: string;
    stateEx?: string;
    traces?: {
      acceptStation?: string;
      acceptTime?: string;
      action?: string;
      location?: string;
    }[];
  };
  /**
   * 订单编号
   */
  orderNo: string;
  /**
   * 订单实付总额
   */
  orderTotalAmount?: number;
  /**
   * 订单类型，0正常订单、1意向订单
   */
  orderType?: number;
  /**
   * 其他方式支付额度
   */
  otherAmount?: number;
  /**
   * 用户支付凭证
   */
  payDTOList?: {
    /**
     * 审核状态，0待审批，1通过，2未通过
     */
    checkStatus?: number;
    /**
     * 提交时间
     */
    createTime?: Date;
    /**
     * id
     */
    id?: number;
    /**
     * 支付凭证
     */
    payImgList: string;
    /**
     * 备注信息
     */
    payRemark?: string;
    /**
     * 未通过原因
     */
    refuseReason?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  }[];
  /**
   * 支付时间
   */
  payTime?: Date;
  /**
   * 支付方式，wechatpay微信，alipay支付宝
   */
  payType?: string;
  /**
   * 评价状态
   */
  remarkStatus?: number;
  /**
   * 卖家备注
   */
  sellerRemark?: string;
  /**
   * 抵扣云享金余额
   */
  shareAmount?: number;
  /**
   * 订单规格列表
   */
  skuDTOList: {
    /**
     * 下单时间
     */
    createTime?: Date;
    /**
     * 订单规格id
     */
    id?: number;
    /**
     * 商品id
     */
    mallGoodsId?: number;
    /**
     * 购买数量
     */
    orderNum: number;
    /**
     * 商品规格id
     */
    priceStockId?: number;
    /**
     * 商品规格
     */
    productSpec: string;
    /**
     * 商品规格图片
     */
    skuImage?: string;
    /**
     * 商品规格编号
     */
    skuNo?: string;
    /**
     * 商品名称
     */
    tradeName?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
    /**
     * 单价
     */
    unitPrice?: number;
  }[];
  /**
   * 订单状态
   */
  statusCode: number;
  /**
   * 卖家id
   */
  thirdBackUserAccountId?: number;
  uavOrderExpressDTO: {
    /**
     * id
     */
    id: number;
    /**
     * 是否已取件，0未取，1已取
     */
    receive?: number;
    /**
     * 取件时间
     */
    receiveTime?: Date;
    /**
     * 快递编码
     */
    sendExpCode?: string;
    /**
     * 快递编号
     */
    sendExpNo?: string;
    /**
     * 发货-收货详细地址
     */
    takeAddress: string;
    /**
     * 取货人
     */
    takeName: string;
    /**
     * 取货人号码
     */
    takePhone: string;
    /**
     * 地区信息
     */
    takeRegion: string;
    /**
     * 订单id
     */
    uavOrderId: number;
  };
  /**
   * 最近修改时间
   */
  updateTime?: Date;
  /**
   * 买家id
   */
  userAccountId?: number;
  /**
   * 收货地址id
   */
  userAddressId?: number;
  /**
   * 买家备注
   */
  userRemark?: string;
  /**
   * 修改版本
   */
  version?: number;
  /**
   * 抵扣钱包余额
   */
  walletAmount?: number;
  userName: string;
  phoneNum: string;
  nickname: string;
  contractInfoDTO?: {
    id: number;
    unionId: string;
    orderNo: string;
    contractNo: string;
    contractTitle: string;
    signStatus: number;
    singerTime: null;
    createTime: string;
    updateTime: string;
    archiveDate: string;
    aremark: string;
    bremark: string;
    atransactionId: string;
    btransactionId: string;
  };
};
export type mallOrderListType = InterListFunction<
  {
    /**
     * 结束时间
     */
    endTime?: string;
    /**
     * 关键字-订单编号
     */
    keyword?: string;
    /**
     * 开始时间
     */
    startTime?: string;
    /**
     * 订单状态码
     */
    statusCode?: number;
    /**
     * 用户uid
     */
    uid?: string;
  },
  mallOrderType
>;
// 商城订单-详情（新）
export type mallOrderDetailType = InterFunction<{ id: number }, mallOrderType>;
// 商城订单-状态字典（新）
export type mallOrderStatusType = InterFunction<
  any,
  {
    code: number;
    nextCode: number;
    status: string;
    id: number;
  }[]
>;

// 商城订单-发货
export type mallOrderSendType = InterFunction<
  {
    /**
     * 快递编码
     */
    sendExpCode?: string;
    /**
     * 快递编号
     */
    sendExpNo?: string;
    /**
     * 发货-收货详细地址
     */
    takeAddress?: string;
    /**
     * 取货人
     */
    takeName?: string;
    /**
     * 取货人号码
     */
    takePhone?: string;
    /**
     * 地区信息
     */
    takeRegion?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
    id?: number;
  },
  any
>;
// 商城订单-卖家备注
export type sellerRemarkType = InterFunction<
  {
    /**
     * content
     */
    content: string;
    /**
     * id
     */
    id: number;
  },
  any
>;
// 商城订单-确认订单
export type confirmOrderType = InterFunction<
  {
    /**
     * 订单交期
     */
    deliveryTime: string;
    /**
     * 订单id
     */
    id: number;
    /**
     * 订单实付总额
     */
    orderTotalAmount?: number;
    /**
     * 卖家备注
     */
    sellerRemark?: string;
  },
  any
>;
// 根据用户id获取钱包信息
export type walletAmountType = InterFunction<
  { userAccountId?: number },
  {
    /**
     * 云享金余额
     */
    cashAmt?: number;
    /**
     * 已冻结云享金
     */
    cashFreeze?: number;
    /**
     * id
     */
    id?: number;
    /**
     * 已提现的金额
     */
    rebateWdl?: number;
    /**
     * 佣金余额
     */
    salaryAmt?: number;
    /**
     * 已冻结佣金
     */
    salaryFreeze?: number;
    /**
     * 总金额
     */
    totalAmount?: number;
    /**
     * 云享金总金额
     */
    totalCash?: number;
    /**
     * 冻结总额
     */
    totalFreeze?: number;
    /**
     * 佣金总额度
     */
    totalSalary?: number;
    /**
     * 用户ID
     */
    userAccountId?: number;
    /**
     * 用户姓名
     */
    userName?: string;
    /**
     * 提现冻结金额
     */
    wdlFreeze?: number;
  }
>;
// 商城订单-凭证审批
export type approvalOrderType = InterFunction<
  {
    /**
     * 审核状态，0待审批，1通过，2未通过
     */
    checkStatus: number;
    /**
     * 支付凭证
     */
    payImgList?: string;
    /**
     * 未通过原因
     */
    refuseReason?: string;
    /**
     * 订单id
     */
    uavOrderId: number;
    id: number;
  },
  any
>;

// 采购订单-列表
type purchaseOrderItemType = {
  id: number;
  orderNo: string;
  backUserAccountId: number;
  thirdUserAccountId: number;
  uavOrderId: number;
  orderAmount: number;
  statusCode: number;
  createTime: number;
  userRemark: null;
  sellerRemark: null;
  skuDTOList: {
    /**
     * 下单时间
     */
    createTime?: Date;
    /**
     * 订单规格id
     */
    id?: number;
    /**
     * 商品id
     */
    mallGoodsId?: number;
    /**
     * 购买数量
     */
    orderNum: number;
    /**
     * 商品规格id
     */
    priceStockId?: number;
    /**
     * 商品规格
     */
    productSpec: string;
    /**
     * 商品规格图片
     */
    skuImage?: string;
    /**
     * 商品规格编号
     */
    skuNo?: string;
    /**
     * 商品名称
     */
    tradeName?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
    /**
     * 单价
     */
    unitPrice?: number;
  }[];
  uavOrderExpressDTO: {
    id: number;
    uavOrderId: number;
    sendExpNo: string;
    sendExpCode: string;
    takeName: string;
    takePhone: string;
    takeRegion: string;
    takeAddress: string;
    sendTime: number;
    receiveTime: null;
    receive: number;
  };
  uavOrderPayDTOS: Array<unknown>;
  contractInfoDTO?: {
    id: number;
    unionId: string;
    orderNo: string;
    contractNo: string;
    contractTitle: string;
    signStatus: number;
    singerTime: null;
    createTime: string;
    updateTime: string;
    archiveDate: null;
    aremark: string;
    bremark: null;
    atransactionId: string;
    btransactionId: null;
  };
  companyName: string;
  thirdPhoneNum: string;
  payDTOS: {
    /**
     * 审核状态，0待审批，1通过，2未通过
     */
    checkStatus?: number;
    /**
     * 提交时间
     */
    createTime?: Date;
    /**
     * id
     */
    id?: number;
    /**
     * 支付凭证
     */
    payImgList: string;
    /**
     * 备注信息
     */
    payRemark?: string;
    /**
     * 未通过原因
     */
    refuseReason?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  }[];
  kdnExpDTO?: {
    logisticCode?: string;
    shipperCode?: string;
    stateEx?: string;
    traces?: {
      acceptStation?: string;
      acceptTime?: string;
      action?: string;
      location?: string;
    }[];
  };
  uavOrderNo: string;
  buyCompanyName: string;
  phoneNum: string;
};
export type listPurchaseOrderType = InterListFunction<
  {
    /**
     * 结束时间
     */
    endTime?: string;
    /**
     * 关键字-订单编号
     */
    keyword?: string;
    /**
     * 开始时间
     */
    startTime?: string;
    /**
     * 订单状态码
     */
    statusCode?: number;
    /**
     * 商家id
     */
    thirdBackUserAccountId?: number;
    /**
     * 用户uid
     */
    uid?: string;
  },
  purchaseOrderItemType
>;
// 采购订单-详情
export type purchaseOrderDetailType = InterFunction<
  {
    /**
     * id
     */
    id: number;
  },
  purchaseOrderItemType
>;
// 采购订单-确认
export type confirmPOrderType = InterFunction<
  {
    /**
     * 采购订单id
     */
    id?: number;
    /**
     * 订单金额
     */
    orderAmount?: number;
    /**
     * 平台备注
     */
    userRemark?: string;
  },
  any
>;
// 采购订单-上传付款凭证
export type uploadPOrderType = InterFunction<
  {
    /**
     * 审核状态，0待审批，1通过，2未通过
     */
    checkStatus?: number;
    /**
     * 支付凭证
     */
    payImgList?: string;
    /**
     * 备注信息
     */
    payRemark?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  },
  any
>;
// 采购订单-审核
export type uavPoCheckPayType = InterFunction<
  {
    /**
     * 审核状态，0待审批，1通过，2未通过
     */
    checkStatus?: number;
    /**
     * id
     */
    id?: number;
    /**
     * 未通过原因
     */
    refuseReason?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  },
  any
>;
// 采购订单-发货
export type uavPoSendType = InterFunction<
  {
    /**
     * 快递编码
     */
    sendExpCode?: string;
    /**
     * 快递编号
     */
    sendExpNo?: string;
    /**
     * 发货-收货详细地址
     */
    takeAddress?: string;
    /**
     * 取货人
     */
    takeName?: string;
    /**
     * 取货人号码
     */
    takePhone?: string;
    /**
     * 地区信息
     */
    takeRegion?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  },
  any
>;

// 采购订单-平台备注
export type uavPoRemarkType = InterFunction<
  {
    /**
     * content
     */
    content: string;
    /**
     * id
     */
    id: number;
  },
  any
>;
// 采购订单-商家备注
export type uavPoSellerRemarkType = InterFunction<
  {
    /**
     * content
     */
    content: string;
    /**
     * id
     */
    id: number;
  },
  any
>;

//租赁-订单列表
type rentReqType = {
  deposit: number;
  /**
   * 卖家企业名称
   */
  companyName?: string;
  /**
   * 确认收货时间
   */
  confirmReceiptTime?: Date;
  /**
   * 下单时间
   */
  createTime?: Date;
  /**
   * 租赁结束时间
   */
  endDate?: Date;
  /**
   * id
   */
  id: number;
  kdnExpDTO?: {
    logisticCode?: string;
    shipperCode?: string;
    stateEx?: string;
    traces?: {
      acceptStation?: string;
      acceptTime?: string;
      action?: string;
      location?: string;
    }[];
  };
  /**
   * 租赁商品id
   */
  leaseGoodsId?: number;
  leaseRefundOrder?: {
    /**
     * 创建时间
     */
    createTime?: Date;
    /**
     * 物流编号
     */
    expressCode?: string;
    /**
     * 快递单号
     */
    expressNum?: string;
    /**
     * 图片文件
     */
    file?: string;
    /**
     * id
     */
    id?: number;
    /**
     * 订单id
     */
    leaseOrderId?: number;
    /**
     * 退款原因
     */
    reason?: string;
    /**
     * 归还状态：0已归还 1无需归还
     */
    status?: number;
  };
  /**
   * 运费
   */
  modeOfDeliveryInfo?: string;
  /**
   * 订单需付金额
   */
  needPayAmount?: number;
  /**
   * 买家昵称
   */
  nickname?: string;
  /**
   * 订单名称
   */
  orderName?: string;
  /**
   * 订单编号
   */
  orderNo?: string;
  /**
   * 订单实付总额
   */
  orderTotalAmount?: number;
  /**
   * 其他方式支付额度
   */
  otherAmount?: number;
  /**
   * 支付时间
   */
  payTime?: Date;
  /**
   * wechatpay微信，alipay支付宝，offline线下
   */
  payType?: string;
  /**
   * 买家手机号
   */
  phoneNum?: string;
  /**
   * 评价状态
   */
  remarkStatus?: number;
  /**
   * 抵扣佣金余额
   */
  salaryAmount?: number;
  /**
   * 卖家备注
   */
  sellerRemark?: string;
  /**
   * 抵扣云享金余额
   */
  shareAmount?: number;
  /**
   * 订单规格列表
   */
  sku: string;
  /**
   * sku图片
   */
  skuImg?: string;
  /**
   * 租赁开始时间
   */
  startDate?: Date;
  /**
   * 订单状态
   */
  statusCode: number;
  storeReceiveOrder?: {
    /**
     * 创建时间
     */
    createTime?: Date;
    /**
     * 物流编号
     */
    expressCode?: string;
    /**
     * 快递单号
     */
    expressNum?: string;
    /**
     * 图片文件
     */
    file?: string;
    /**
     * id
     */
    id?: number;
    /**
     * 订单id
     */
    leaseOrderId?: number;
    /**
     * 退款原因
     */
    reason?: string;
    /**
     * 归还状态：0已归还 1无需归还
     */
    status?: number;
  };
  /**
   * 卖家id
   */
  thirdBackUserAccountId?: number;
  uavOrderExpressDTO?: {
    /**
     * id
     */
    id?: number;
    /**
     * 是否已取件，0未取，1已取
     */
    receive?: number;
    /**
     * 取件时间
     */
    receiveTime?: Date;
    /**
     * 快递编码
     */
    sendExpCode?: string;
    /**
     * 快递编号
     */
    sendExpNo?: string;
    /**
     * 发货-平台操作发货时间
     */
    sendTime?: Date;
    /**
     * 发货-收货详细地址
     */
    takeAddress?: string;
    /**
     * 取货人
     */
    takeName?: string;
    /**
     * 取货人号码
     */
    takePhone?: string;
    /**
     * 地区信息
     */
    takeRegion?: string;
    /**
     * 订单id
     */
    uavOrderId?: number;
  };
  /**
   * 最近修改时间
   */
  updateTime?: Date;
  /**
   * 买家id
   */
  userAccountId?: number;
  /**
   * 买家姓名
   */
  userName?: string;
  /**
   * 买家备注
   */
  userRemark?: string;
  /**
   * 购买数量
   */
  wareNum: number;
  shareCashPledge?: number;
  salaryCashPledge?: number;
};
export type rentOrderListType = InterListFunction<
  {
    /**
     * 结束时间
     */
    endTime?: string;
    /**
     * 关键字-订单编号
     */
    keyword?: string;
    /**
     * 开始时间
     */
    startTime?: string;
    /**
     * 订单状态码
     */
    statusCode?: number;
    /**
     * 用户uid
     */
    uid?: string;
  },
  rentReqType
>;
// 租赁-订单字典
export type rentOrderDictType = InterFunction<
  any,
  {
    status: string;
    doing: string;
    waiting: string;
    leaseOrderStatus: null;
  }[]
>;
// 租赁-订单详情
export type rentOrderDetailType = InterFunction<
  {
    /**
     * id
     */
    id: number;
  },
  rentReqType
>;
// 租赁订单-发货
export type rentOrderSendType = InterFunction<
  {
    id: number;
    /**
     * 快递编码
     */
    sendExpCode: string;
    /**
     * 快递编号
     */
    sendExpNo: string;
    /**
     * 发货-收货详细地址
     */
    takeAddress: string;
    /**
     * 取货人
     */
    takeName: string;
    /**
     * 取货人号码
     */
    takePhone: string;
    /**
     * 地区信息
     */
    takeRegion: string;
    /**
     * 订单id
     */
    uavOrderId: number;
  },
  any
>;
