import axios from 'axios';
// import {baseURL} from './index';
const baseURL = 'https://testapi.sharefly.mmcuav.cn/';

const Axios = axios.create({
  baseURL,
  timeout: 60000,
});
Axios.interceptors.request.use(
  (config: any) => {
    const token = false; //此处获取token
    if (token) {
      config.headers.token = token;
    }
    return config;
  },
  error => {
    return Promise.reject(error);
  },
);

Axios.interceptors.response.use(
  response => {
    const res = response.data;
    if (res.code === '200') {
      return Promise.resolve(res);
    } else {
      console.log('err -->', res);
      return Promise.resolve(res);
    }
  },
  error => {
    if (error.response) {
      console.log(error.response.status, error.response.statusText);
    }
    return Promise.reject(error);
  },
);

export default Axios;
