import { Form, Input, message, Modal, ModalProps } from 'antd';
import { FC, useEffect } from 'react';
import { InterDataType } from '~/api/interface';
import { backListPilotType } from '~/api/interface/flyerCenterType';
import { FlyerCenterAPI } from '~/api';

//飞手列表返回类型
type flyerListType = InterDataType<backListPilotType>['list'];
interface selfProps {
  onOk: () => void;
  flyerItem: flyerListType[0] | undefined;
}

const UpdateRemarkModal: FC<ModalProps & selfProps> = ({ open, onCancel, onOk, flyerItem }) => {
  const [form] = Form.useForm<{ remark: string }>();

  const handleOk = () => {
    if (flyerItem) {
      form.validateFields().then((values) => {
        FlyerCenterAPI.updateRemark({ id: flyerItem.id, ...values }).then(({ code }) => {
          if (code === '200') {
            message.success('编辑备注成功');
            onOk();
          }
        });
      });
    }
  };

  useEffect(() => {
    if (flyerItem) {
      form.setFieldValue('remark', flyerItem.remark);
    }
  }, [flyerItem]);
  return (
    <Modal open={open} onCancel={onCancel} onOk={handleOk} title='备注修改'>
      <Form form={form}>
        <Form.Item label='备注' name='remark'>
          <Input.TextArea placeholder='请输入备注' maxLength={70} showCount rows={4} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default UpdateRemarkModal;
