import axios from '../request';
import {
  approvalOrderType,
  confirmOrderType,
  confirmPOrderType,
  disputeType,
  flowDictionaryAndTimeType,
  flowDictionaryType,
  getMallOrderDetailById,
  listExpressInfoType,
  listOfRentalOrdersType,
  listPageManagerVerOne,
  listPcWechatOrderType,
  listPurchaseOrderType,
  listTranStatusType,
  logisticsDynamicsType,
  mallOrderDetailType,
  mallOrderListType,
  mallOrderSendType,
  mallOrderStatusType,
  orderDetailType,
  orderImageDetailType,
  orderListStatus,
  pfConfirmOrderWareType,
  platFormCloseOrderType,
  purchaseOrderDetailType,
  refundOrderType,
  renterTakeOrderType,
  sellerRemarkType,
  sendOrderWareType,
  serviceOrderFormDetailsType,
  serviceOrderFormListType,
  serviceOrderStatusType,
  serviceOrderType,
  uavPoCheckPayType,
  uavPoRemarkType,
  uavPoSellerRemarkType,
  uavPoSendType,
  uploadPOrderType,
  walletAmountType,
  rentOrderListType,
  rentOrderDictType,
  rentOrderSendType,
  rentOrderDetailType,
} from '~/api/interface/orderManageType';

export class OrderManageAPI {
  // web 租赁订单-分页-列表
  static listOfRentalOrders: listOfRentalOrdersType = (params) =>
    axios.post('/oms/RentalOrders/listOfRentalOrders', params);

  // 后台管理 租赁订单-分页-列表
  static listPcWechatOrder: listPcWechatOrderType = (params) =>
    axios.post('/oms/RentalOrders/listPcWechatOrder', params);

  // web/小程序——订单详情
  static orderDetail: orderDetailType = (params) =>
    axios.get('/oms/RentalOrders/orderDetail', { params });

  // 订单状态-字典
  static listTranStatus: listTranStatusType = (params) =>
    axios.get('/oms/RentalOrders/listTranStatus', { params });

  // 后台管理——发货-订单/ 卖家发货
  static sendOrderWare: sendOrderWareType = (params) =>
    axios.post('/oms/RentalOrders/sendOrderWare', params);

  // web/小程序 确认收货-订单
  static renterTakeOrder: renterTakeOrderType = (params) =>
    axios.post('/oms/RentalOrders/renterTakeOrder', params);

  // web/小程序 确认收货-订单
  static pfConfirmOrderWare: pfConfirmOrderWareType = (params) =>
    axios.post('/oms/RentalOrders/pfConfirmOrderWare', params);

  // v1.0.1 物流公司列表-字典
  static listExpressInfo: listExpressInfoType = (params) =>
    axios.get('/oms/express/listExpressInfo', { params });
  // 物流动态信息
  static getLogisticsDynamics: logisticsDynamicsType = (params) =>
    axios.get('/oms/express/logisticsDynamics', { params });

  // web-小程序——订单详情相关图片信息
  static orderImageDetail: orderImageDetailType = (params) =>
    axios.get('/oms/RentalOrders/orderImageDetail', { params });

  // 后台管理关闭订单
  static platFormCloseOrder: platFormCloseOrderType = (params) =>
    axios.get('/oms/RentalOrders/platFormCloseOrder', { params });

  // 后台管理——驳回/同意退款
  static refundOrder: refundOrderType = (params) => axios.post('/oms/refund/refund', params);

  // 商城订单-订单状态-字典
  static orderListStatus: orderListStatus = (params) =>
    axios.get('/oms/mallorder/listStatus', { params });

  // v1.0.0订单管理-分页查询（改版后）
  static listPageManagerVerOne: listPageManagerVerOne = (params) =>
    axios.post('/oms/pmorderVerOne/listPageManagerVerOne', params);

  // v1.0.0订单管理-详情（改版后）
  static getMallOrderDetailById: getMallOrderDetailById = (params) =>
    axios.get('/oms/pmorderVerOne/getMallOrderDetailById', { params });
  //  服务-订单
  static getServiceOrderList: serviceOrderType = (data) =>
    axios.post('/oms/serviceOrderTask/queryOrderTaskList', data);
  //  服务-订单字典
  static getServiceStatusList: serviceOrderStatusType = () =>
    axios.post('/oms/serviceOrderTask/getServiceOrderStatus');

  //需求订单-列表
  static getServiceOrderFormList: serviceOrderFormListType = (data) =>
    axios.post('/release/backRequirements/serviceOrderFormList', data);
  //   需求订单-详情
  static getServiceOrderFormDetails: serviceOrderFormDetailsType = (params) =>
    axios.get('/release/backRequirements/serviceOrderFormDetails', { params });
  //   需求订单-进度条（带时间）
  static getFlowDictionaryAndTime: flowDictionaryAndTimeType = (params) =>
    axios.get('/release/requirements/flowDictionaryAndTime', { params });
  //   需求订单-进度条
  static getFlowDictionary: flowDictionaryType = () =>
    axios.get('/release/requirements/flowDictionary');
  // 需求订单-争议
  static disputeOrder: disputeType = (data) => axios.post('/release/requirements/cancelAll', data);

  //    商城订单-列表（新）
  static getMallOrderList: mallOrderListType = (data) => axios.post('/oms/uav-order/list', data);
  //   商城订单-状态字典（新）
  static getMallOrderStatusList: mallOrderStatusType = () => axios.get('/oms/uav-order/statusList');
  //   商城订单-详情（新）
  static getMallOrderDetail: mallOrderDetailType = (params) =>
    axios.get('/oms/uav-order/detail', { params });
  //   商城订单-发货（新）
  static mallOrderSend: mallOrderSendType = (data) => axios.post('/oms/uav-order/send', data);
  //   商城订单-卖家备注
  static sellerRemark: sellerRemarkType = (params) =>
    axios.get('/oms/uav-order/sellerRemark', { params });
  //   商城订单-确认订单
  static confirmOrder: confirmOrderType = (data) => axios.post('/oms/uav-order/confirmOrder', data);
  // 根据用户id获取钱包信息
  static getWalletAmount: walletAmountType = (params) =>
    axios.get('/userapp/pay/getPayWalletInfo', { params });
  //   商城订单-审批凭证
  static approvalOrder: approvalOrderType = (data) => axios.post('/oms/uav-order/checkPay', data);
  //   采购订单-列表
  static getListPurchaseOrder: listPurchaseOrderType = (data) =>
    axios.post('/oms/uav-po/listPurchaseOrder', data);
  //   采购订单-详情
  static getPurchaseOrderDetail: purchaseOrderDetailType = (params) =>
    axios.get('/oms/uav-po/getPurchaseOrder', { params });
  //   采购订单-确认
  static confirmPOrder: confirmPOrderType = (data) => axios.post('/oms/uav-po/confirmPOrder', data);
  //   采购订单-上传付款凭证
  static uploadPOrder: uploadPOrderType = (data) => axios.post('/oms/uav-po/upLoadPay', data);
  // 采购订单-审核
  static uavPoCheckPay: uavPoCheckPayType = (data) => axios.post('/oms/uav-po/checkPay', data);
  //   采购订单-发货
  static uavPoSend: uavPoSendType = (data) => axios.post('/oms/uav-po/send', data);
  //   采购订单-平台备注
  static setUavPoRemark: uavPoRemarkType = (params) =>
    axios.get('/oms/uav-po/userRemark', { params });
  static setUavPoSellerRemark: uavPoSellerRemarkType = (params) =>
    axios.get('/oms/uav-po/sellerRemark', { params });

  //   租赁-订单列表
  static getRentOrderList: rentOrderListType = (data) => axios.post('/oms/lease/order/list', data);
  //   租赁-订单字典
  static getRentOrderDict: rentOrderDictType = () => axios.get('/oms/lease/order/statusList');
  //   租赁-订单发货
  static rentOrderSend: rentOrderSendType = (data) => axios.post('/oms/lease/order/send', data);
  //   租赁-订单详情
  static getRentOrderDetail: rentOrderDetailType = (params) =>
    axios.get('/oms/lease/order/detail', { params });
}
