import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  reqMenuList: [], //请求的菜单
  menuList: [], //过滤后的菜单
  collapsedActive: false,
  roleId: localStorage.getItem('roleId') ? Number(localStorage.getItem('roleId')) : -1,
};

export const menuSlice = createSlice({
  name: 'menuSlice',
  initialState,
  reducers: {
    SET_MENU(state, action) {
      state.menuList = action.payload;
    },
    SET_REQ_MENU(state, action) {
      state.reqMenuList = action.payload;
    },
    SET_COLLAPSE(state, action) {
      state.collapsedActive = action.payload;
    },
    REMOVE_MENU(state) {
      state.menuList = [];
    },
    REMOVE_REQ_MENU(state) {
      state.reqMenuList = [];
    },
    SET_MENU_ID(state, action) {
      state.roleId = action.payload;
      localStorage.setItem('roleId', action.payload);
    },
    REMOVE_MENU_ID() {
      localStorage.removeItem('roleId');
    },
  },
});

export const {
  SET_MENU,
  SET_COLLAPSE,
  REMOVE_MENU,
  SET_MENU_ID,
  REMOVE_MENU_ID,
  REMOVE_REQ_MENU,
  SET_REQ_MENU,
} = menuSlice.actions;

export const Menu = menuSlice.reducer;
