import React, { useEffect, useState } from 'react';
import { InterDataType } from '~/api/interface';
import { getCompanyInfoByIdType } from '~/api/interface/systemManageType';
import { CustomManageAPI } from '~/api';
import { Button, Table, Modal, message } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { getBusinessCaseType } from '~/api/interface/customManageType';
import { ColumnsType } from 'antd/es/table';
import AddBusinessCase from '~/pages/resourceManage/storeDecorate/comp/addBusinessCase';
import Video from '~/components/video';

// 店铺类型
type DetailType = InterDataType<getCompanyInfoByIdType>;
// 列表类型
type ListType = InterDataType<getBusinessCaseType>;

const StoreBusinessCase: React.FC<{
  detail: DetailType;
}> = ({ detail }) => {
  // 添加解决方案是否显示
  const [isAddSolution, setIsAddSolution] = useState<boolean>(false);
  // 当前编辑的数据
  const [editData, setEditData] = useState<ListType[0]>();
  // 解决方案列表
  const [businessList, setBusinessList] = useState<ListType>([]);
  // 获取解决方案列表
  const getSolutionList = async () => {
    const res = await CustomManageAPI.getBusinessCase({
      backUserId: detail?.backUserId,
    });
    if (res && res.code === '200') {
      setBusinessList(res.result);
      // console.log('获取解决方案列表 --->', res.result);
    }
  };
  // 删除事件
  const handleDelete = (record: ListType[0]) => {
    Modal.confirm({
      title: '提示',
      content: '删除后将无法恢复，是否确认删除？',
      onOk: async () => {
        const res = await CustomManageAPI.deleteBusinessCase({
          id: record?.id,
        });
        if (res && res.code === '200') {
          await getSolutionList();
          message.success('删除成功');
        }
      },
    });
  };
  // 组件挂载
  useEffect(() => {
    if (detail?.backUserId) getSolutionList().then();
    // console.log('storeSolutionView --->', detail);
  }, []);
  const columns: ColumnsType<ListType[0]> = [
    {
      title: '序号',
      dataIndex: 'accountNo',
      align: 'center',
      width: '50px',
      render: (_text, _record, index) => index + 1,
    },
    {
      title: '案例说明',
      dataIndex: 'businessDescription',
      align: 'center',
    },
    {
      title: '案例视频',
      dataIndex: 'businessVideo',
      align: 'center',
      render: (text) => <Video src={text} width={40} height={40} />,
    },
    {
      title: '操作',
      dataIndex: 'action',
      align: 'center',
      render: (_text, record) => (
        <>
          <Button
            type={'link'}
            onClick={() => {
              setEditData(record);
              setIsAddSolution(true);
            }}
          >
            编辑
          </Button>
          <Button type={'link'} onClick={() => handleDelete(record)} danger>
            删除
          </Button>
        </>
      ),
    },
  ];
  return (
    <>
      <div className={'store-title flex-between'}>
        <div className='title'>企业业务案例</div>
        <div className='action'>
          <Button icon={<PlusOutlined />} type={'primary'} onClick={() => setIsAddSolution(true)}>
            添加企业案例
          </Button>
        </div>
      </div>
      <Table
        dataSource={businessList}
        rowKey={'id'}
        columns={columns}
        size={'small'}
        bordered={true}
      ></Table>
      <AddBusinessCase
        open={isAddSolution}
        detail={detail}
        data={editData}
        title={editData?.id ? '编辑企业案例' : '添加企业案例'}
        onCancel={() => {
          setIsAddSolution(false);
          setEditData(undefined);
          getSolutionList().then();
        }}
      />
    </>
  );
};

export default StoreBusinessCase;
