// eslint-disable-next-line @typescript-eslint/ban-ts-comment
// @ts-nocheck
import AMapLoader from '@amap/amap-jsapi-loader';
import { Component } from 'react';

interface MapComponentProps {
  onSelectAddress: (e: {
    adcode: string;
    building: string;
    buildingType: string;
    city: string;
    citycode: string;
    district: string;
    formattedAddress: string;
    neighborhood: string;
    neighborhoodType: string;
    province: string;
    street: string;
    streetNumber: string;
    towncode: string;
    township: string;
    lat: number;
    lng: number;
  }) => void;
  onSearchAddress: (
    e: {
      id: string;
      name: string;
      district: string;
      adcode: string;
      location: Array<number>;
      address: string;
      typecode: string;
    }[],
  ) => void;
}

class MapComponent extends Component<MapComponentProps> {
  constructor(props) {
    super(props);
    this.map = {};
    this.autoComplete = {};
  }

  // dom渲染成功后进行map对象的创建
  componentDidMount() {
    AMapLoader.load({
      key: '7a3a24e85672c06ab466d790fb5d38a3', // 申请好的Web端开发者Key，首次调用 load 时必填
      version: '2.0', // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
      plugins: [], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
    })
      .then((AMap) => {
        this.map = new AMap.Map('container', {
          // 设置地图容器id
          viewMode: '3D', // 是否为3D地图模式
          zoom: 10, // 初始化地图级别
          // center: [105.602725, 37.076636], // 初始化地图中心点位置
        });
        AMap.plugin(
          ['AMap.ToolBar', 'AMap.AutoComplete', 'AMap.Scale', 'AMap.Geocoder', 'AMap.Marker'],
          () => {
            // 缩放
            const scale = new AMap.Scale();
            this.map.addControl(scale);
            // 工具栏
            const toolbar = new AMap.ToolBar();
            this.map.addControl(toolbar);
            // 位置搜索
            const autoOptions = {
              //city 限定城市，默认全国
              city: '全国',
            };
            // 实例化AutoComplete
            this.autoComplete = new AMap.AutoComplete(autoOptions);
          },
        );
        this.map.on('click', (e) => {
          this.map.clearMap();
          const { lat, lng } = e.lnglat;
          // 新建marker实例
          const marker = new AMap.Marker({
            position: new AMap.LngLat(lng, lat), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
            title: '选择的位置',
          });
          // 添加marker
          this.map.add(marker);
          // 获取地理信息
          const geocoder = new AMap.Geocoder({
            city: '全国',
          });
          // console.log('点击 --->', e);
          geocoder.getAddress([lng, lat], (status, result) => {
            if (status === 'complete' && result.info === 'OK') {
              // result为对应的地理位置详细信息
              const { formattedAddress, addressComponent } = result.regeocode;
              console.log('点击选择-->', status, result);
              this.props.onSelectAddress({
                lat,
                lng,
                formattedAddress,
                ...addressComponent,
              });
            }
          });
        });
      })
      .catch((e) => {
        console.log(e);
      });
  }
  componentWillUnmount() {
    this.map.destroy();
  }
  // 搜索数据
  onSearch(keyword: string) {
    // 根据关键字进行搜索
    this.autoComplete.search(keyword, (status, result) => {
      // 搜索成功时，result即是对应的匹配数据
      if (status === 'complete' && result.info === 'OK') {
        this.props.onSearchAddress(result.tips);
      }
    });
  }
  // 添加点标记
  addMarker(e: { lat: number; lng: number }) {
    const { lat, lng } = e;
    this.map.clearMap();
    // 新建marker实例
    const marker = new AMap.Marker({
      position: new AMap.LngLat(lng, lat), // 经纬度对象，也可以是经纬度构成的一维数组[116.39, 39.9]
      title: '选择的位置',
    });
    // 添加marker
    this.map.add(marker);
    // 设置中心点
    this.map.setCenter([lng, lat]);
  }
  // 清除地图上的点标记
  clearMarker() {
    this.map.clearMap();
  }

  render() {
    // 初始化创建地图容器,div标签作为地图容器，同时为该div指定id属性；
    return <div id='container' className='map' style={{ height: '400px' }}></div>;
  }
}
// 导出地图组建类
export default MapComponent;
